/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.dom4j.DocumentException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ClusterMessageAware;
import org.springframework.extensions.surf.ClusterService;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Extension;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.webscripts.Registry;

public class ModuleDeploymentService
implements ClusterMessageAware {
    private static final Log logger = LogFactory.getLog(ModuleDeploymentService.class);
    private WebFrameworkConfigElement webFrameworkConfiguration;
    private ModelObjectService modelObjectService;
    private Registry webScriptRegistry = null;
    private Date lastConfigurationUpdate = new Date();
    private ThreadLocal<List<String>> currThreadErrors = new ThreadLocal();
    private Map<String, ExtensionModule> configuredModules = null;
    private List<ExtensionModule> undeployedModules = null;
    private List<ModuleDeployment> deployedModules = null;
    public static final String DEFAULT_PERSISTED_EXTENSION = "default-persisted-extension";
    protected ClusterService clusterService;

    public void setWebFrameworkConfiguration(WebFrameworkConfigElement webFrameworkConfiguration) {
        this.webFrameworkConfiguration = webFrameworkConfiguration;
    }

    public ModelObjectService getModelObjectService() {
        return this.modelObjectService;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setWebScriptRegistry(Registry webScriptRegistry) {
        this.webScriptRegistry = webScriptRegistry;
    }

    public synchronized Date getLastConfigurationUpdate() {
        return this.lastConfigurationUpdate;
    }

    public List<String> getCurrentThreadErrors() {
        List<String> currErrors = this.currThreadErrors.get();
        if (currErrors == null) {
            currErrors = new ArrayList<String>();
        }
        return currErrors;
    }

    public void clearCurrentThreadErrors() {
        this.currThreadErrors.get().clear();
    }

    public synchronized Extension getPersistedExtension() throws ModelObjectPersisterException {
        Extension extension = (Extension)this.modelObjectService.getObject("extension", DEFAULT_PERSISTED_EXTENSION);
        if (extension == null) {
            extension = (Extension)this.modelObjectService.newObject("extension", DEFAULT_PERSISTED_EXTENSION);
            this.modelObjectService.saveObject(extension);
        }
        return extension;
    }

    public synchronized boolean addModuleToExtension(String xmlFragment) throws DocumentException, ModelObjectPersisterException {
        boolean result = false;
        if (this.webFrameworkConfiguration.isDynamicExtensionModulesEnabled()) {
            Extension persistedExtension = this.getPersistedExtension();
            ExtensionModule module = persistedExtension.addExtensionModule(xmlFragment);
            if (module != null) {
                this.modelObjectService.saveObject(persistedExtension);
                this.configuredModules.put(module.getId(), module);
                String moduleDeploymentMode = this.webFrameworkConfiguration.getModuleDeploymentMode();
                if (moduleDeploymentMode == null || moduleDeploymentMode.equals("auto")) {
                    this.deployedModules.add(this.deployModule(module, this.deployedModules.size() + 1, null, null));
                } else if (this.webFrameworkConfiguration.isModuleAutoDeployEnabled() && module.isAutoDeploy()) {
                    this.deployedModules.add(this.deployModule(module, this.deployedModules.size() + 1, null, null));
                } else {
                    this.undeployedModules.add(module);
                }
            }
            this.saveDeployedModuleConfigurations();
            this.updateClusterCache();
            result = module != null;
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A request was made to add an Extension Module but dynamic modules are disabled");
        }
        return result;
    }

    public synchronized boolean updateModuleToExtension(String xmlFragment) throws DocumentException, ModelObjectPersisterException {
        boolean result = false;
        if (this.webFrameworkConfiguration.isDynamicExtensionModulesEnabled()) {
            Extension persistedExtension = this.getPersistedExtension();
            ExtensionModule module = persistedExtension.updateExtensionModule(xmlFragment);
            if (module != null) {
                String moduleDeploymentMode;
                this.modelObjectService.saveObject(persistedExtension);
                this.configuredModules.put(module.getId(), module);
                ModuleDeployment deployedModule = null;
                for (ModuleDeployment depMod : this.deployedModules) {
                    if (!depMod.getExtensionModuleId().equals(module.getId())) continue;
                    deployedModule = depMod;
                    break;
                }
                if (deployedModule != null) {
                    this.deployedModules.remove(deployedModule);
                }
                if ((moduleDeploymentMode = this.webFrameworkConfiguration.getModuleDeploymentMode()) == null || moduleDeploymentMode.equals("auto")) {
                    this.deployedModules.add(this.deployModule(module, this.deployedModules.size() + 1, null, null));
                } else if (this.webFrameworkConfiguration.isModuleAutoDeployEnabled() && module.isAutoDeploy()) {
                    this.deployedModules.add(this.deployModule(module, this.deployedModules.size() + 1, null, null));
                } else {
                    this.undeployedModules.add(module);
                }
            }
            this.saveDeployedModuleConfigurations();
            this.updateClusterCache();
            result = module != null;
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A request was made to update an Extension Module but dynamic modules are disabled");
        }
        return result;
    }

    public synchronized boolean deleteModuleFromExtension(String moduleId) throws ModelObjectPersisterException, DocumentException {
        boolean result = false;
        if (this.webFrameworkConfiguration.isDynamicExtensionModulesEnabled()) {
            Extension persistedExtension = this.getPersistedExtension();
            ExtensionModule deletedModule = persistedExtension.deleteExtensionModule(moduleId);
            if (deletedModule != null) {
                this.modelObjectService.saveObject(persistedExtension);
                this.configuredModules.remove(deletedModule.getId());
                ModuleDeployment deployedModule = null;
                for (ModuleDeployment depMod : this.deployedModules) {
                    if (!depMod.getExtensionModuleId().equals(deletedModule.getId())) continue;
                    deployedModule = depMod;
                    break;
                }
                if (deployedModule != null) {
                    this.deployedModules.remove(deployedModule);
                    this.modelObjectService.removeObject(deployedModule);
                    this.saveDeployedModuleConfigurations();
                } else {
                    this.undeployedModules.remove((Object)deletedModule);
                }
                this.updateClusterCache();
                result = deletedModule != null;
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A request was made to delete an Extension Module but dynamic modules are disabled");
        }
        return result;
    }

    public synchronized List<ExtensionModule> getUndeployedModules() {
        if (this.undeployedModules == null) {
            this.getDeployedModules();
        }
        return this.undeployedModules;
    }

    private synchronized Map<String, ExtensionModule> getAllConfiguredExtensionModules() {
        if (this.configuredModules == null) {
            this.configuredModules = this.getExtensionModules();
        }
        return this.configuredModules;
    }

    private Map<String, ExtensionModule> getExtensionModules() {
        HashMap<String, ExtensionModule> allModules;
        block6: {
            allModules = new HashMap<String, ExtensionModule>();
            Map<String, ModelObject> allExtensions = this.modelObjectService.getAllObjects("extension");
            for (ModelObject extension : allExtensions.values()) {
                if (!(extension instanceof Extension)) continue;
                for (ExtensionModule module : ((Extension)extension).getExtensionModules()) {
                    allModules.put(module.getId(), module);
                }
            }
            try {
                if (this.webFrameworkConfiguration.isDynamicExtensionModulesEnabled()) {
                    for (ExtensionModule module : this.getPersistedExtension().getExtensionModules()) {
                        allModules.put(module.getId(), module);
                    }
                }
            }
            catch (ModelObjectPersisterException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)"The following error occurred attempting to retrieve persisted extension modules", (Throwable)e);
            }
        }
        return allModules;
    }

    public synchronized List<ModuleDeployment> getDeployedModules() {
        if (this.deployedModules == null) {
            this.getAllConfiguredExtensionModules();
            String moduleDeploymentMode = this.webFrameworkConfiguration.getModuleDeploymentMode();
            if (moduleDeploymentMode == null || moduleDeploymentMode.equals("auto")) {
                this.deployedModules = new ArrayList<ModuleDeployment>();
                ArrayList<ExtensionModule> modsForSorting = new ArrayList<ExtensionModule>(this.configuredModules.values());
                Collections.sort(modsForSorting, new AutoDeployIndexComparator());
                int i = 0;
                for (ExtensionModule module : modsForSorting) {
                    this.deployedModules.add(this.deployModule(module, i++, null, null));
                }
                this.undeployedModules = new ArrayList<ExtensionModule>();
            } else {
                this.undeployedModules = new ArrayList<ExtensionModule>();
                this.undeployedModules.addAll(this.configuredModules.values());
                this.deployedModules = new ArrayList<ModuleDeployment>();
                for (ExtensionModule configuredModule : this.configuredModules.values()) {
                    ModelObject o = this.modelObjectService.getObject("module-deployment", configuredModule.getId());
                    if (!(o instanceof ModuleDeployment)) continue;
                    ModuleDeployment modDep = (ModuleDeployment)o;
                    modDep.setExtensionModule(configuredModule);
                    this.deployedModules.add(modDep);
                    this.undeployedModules.remove((Object)configuredModule);
                }
                Collections.sort(this.deployedModules, new DeployedModuleComparator());
                int i = 0;
                if (!this.deployedModules.isEmpty()) {
                    ModuleDeployment lastDeployedModule = this.deployedModules.get(this.deployedModules.size() - 1);
                    i = lastDeployedModule.getIndex();
                }
                if (this.webFrameworkConfiguration.isModuleAutoDeployEnabled()) {
                    ArrayList<ExtensionModule> autoDeployed = new ArrayList<ExtensionModule>();
                    for (ExtensionModule module : this.undeployedModules) {
                        if (!module.isAutoDeploy()) continue;
                        autoDeployed.add(module);
                    }
                    Collections.sort(autoDeployed, new AutoDeployIndexComparator());
                    for (ExtensionModule module : autoDeployed) {
                        this.deployedModules.add(this.deployModule(module, ++i, null, null));
                    }
                    this.undeployedModules.removeAll(autoDeployed);
                }
            }
            this.saveDeployedModuleConfigurations();
        }
        return this.deployedModules;
    }

    private synchronized void saveDeployedModuleConfigurations() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        if (rc != null && rc.getUser() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Saving module deployment configuration...");
            }
            Collections.sort(this.deployedModules, new DeployedModuleComparator());
            ArrayList<Object> errors = new ArrayList<Object>();
            boolean saveFail = false;
            for (int i = 0; i < this.deployedModules.size(); ++i) {
                ModuleDeployment currentDeployedModule = this.deployedModules.get(i);
                currentDeployedModule.setIndex(i);
                try {
                    if (this.modelObjectService.saveObject(currentDeployedModule)) continue;
                    saveFail = true;
                    errors.add("Could not save module: \"" + currentDeployedModule.getId() + "\"");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not save module deployment for: \"" + currentDeployedModule.getId() + "\""));
                    continue;
                }
                catch (ModelObjectPersisterException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Could not save module deployment configuration", (Throwable)e);
                    }
                    errors.add("The following exception was thrown: " + e.getLocalizedMessage());
                }
            }
            if (saveFail) {
                errors.add("Could not save deployment configuration, please ensure you are authenticated. Changes will not survive server restart.");
            }
            this.lastConfigurationUpdate = new Date();
            this.currThreadErrors.set(errors);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unable to saving module deployment configuration as user does not have required authentication.");
        }
    }

    public synchronized void setDeployedModules(List<JSONObject> modulesToDeploy) throws JSONException {
        this.getAllConfiguredExtensionModules();
        this.getDeployedModules();
        this.getUndeployedModules();
        for (ModuleDeployment depMod : this.deployedModules) {
            String modIdToRemove = depMod.getExtensionModuleId();
            ExtensionModule modToRemove = this.configuredModules.get(modIdToRemove);
            if (!this.undeployedModules.contains((Object)modToRemove)) {
                this.undeployedModules.add(modToRemove);
            }
            this.modelObjectService.removeObject(depMod);
        }
        this.deployedModules.clear();
        if (modulesToDeploy != null) {
            for (int i = 0; i < modulesToDeploy.size(); ++i) {
                ModuleDeployment modDep;
                JSONObject moduleToDeploy = modulesToDeploy.get(i);
                String moduleId = moduleToDeploy.getString("id");
                String evaluatorOverride = null;
                if (moduleToDeploy.has("evaluatorOverrideId")) {
                    evaluatorOverride = moduleToDeploy.getString("evaluatorOverrideId");
                }
                HashMap<String, String> evalPropOverrides = null;
                if (moduleToDeploy.has("evaluatorPropertyOverrides")) {
                    JSONObject evalPropOverridesJSON = moduleToDeploy.getJSONObject("evaluatorPropertyOverrides");
                    evalPropOverrides = new HashMap<String, String>();
                    Iterator propKeys = evalPropOverridesJSON.keys();
                    while (propKeys.hasNext()) {
                        String propKey = (String)propKeys.next();
                        evalPropOverrides.put(propKey, (String)evalPropOverridesJSON.get(propKey));
                    }
                }
                ExtensionModule targetModule = null;
                Iterator<ExtensionModule> extModIter = this.configuredModules.values().iterator();
                while (targetModule == null && extModIter.hasNext()) {
                    ExtensionModule currExtMod = extModIter.next();
                    if (currExtMod == null || currExtMod.getId() == null || !currExtMod.getId().equals(moduleId)) continue;
                    targetModule = currExtMod;
                }
                if (targetModule == null || (modDep = this.deployModule(targetModule, i, evaluatorOverride, evalPropOverrides)) == null) continue;
                this.deployedModules.add(modDep);
                this.undeployedModules.remove((Object)targetModule);
            }
        }
        if (this.webScriptRegistry != null) {
            this.webScriptRegistry.reset();
        }
        this.saveDeployedModuleConfigurations();
    }

    private synchronized ModuleDeployment deployModule(ExtensionModule moduleToDeploy, int index, String evaluatorOverride, Map<String, String> evaluatorPropertyOverrides) {
        ModuleDeployment modDep = (ModuleDeployment)this.modelObjectService.newObject("module-deployment", moduleToDeploy.getId());
        modDep.setIndex(index);
        modDep.setExtensionModuleId(moduleToDeploy.getId());
        modDep.setExtensionModule(moduleToDeploy);
        if (evaluatorOverride != null) {
            modDep.setEvaluatorOverride(evaluatorOverride);
        }
        if (evaluatorPropertyOverrides != null) {
            modDep.setEvaluatorPropertyOverrides(evaluatorPropertyOverrides);
        }
        return modDep;
    }

    public synchronized boolean deleteModuleDeployment(ModuleDeployment moduleDeploymentToDelete) {
        boolean deleted = false;
        List<ExtensionModule> undeployedModules = this.getUndeployedModules();
        List<ModuleDeployment> deployedModules = this.getDeployedModules();
        if (deployedModules.contains(moduleDeploymentToDelete)) {
            undeployedModules.add(this.configuredModules.get(moduleDeploymentToDelete.getExtensionModuleId()));
            this.modelObjectService.removeObject(moduleDeploymentToDelete);
            this.lastConfigurationUpdate = new Date();
            deleted = true;
        }
        return deleted;
    }

    @Override
    public void setClusterService(ClusterService service) {
        this.clusterService = service;
    }

    @Override
    public String getClusterMessageType() {
        return "module-deployment-invalidation";
    }

    @Override
    public synchronized void onClusterMessage(Map<String, Serializable> payload) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Clearing all deployed module caches due to cluster cache invalidation message...");
        }
        this.configuredModules = null;
        this.undeployedModules = null;
        this.deployedModules = null;
    }

    private void updateClusterCache() {
        if (this.clusterService != null) {
            this.clusterService.publishClusterMessage("module-deployment-invalidation", Collections.emptyMap());
        }
    }

    private class AutoDeployIndexComparator
    implements Comparator<ExtensionModule> {
        private AutoDeployIndexComparator() {
        }

        private DefaultArtifactVersion parseAutoDeployIndex(ExtensionModule extMod) {
            DefaultArtifactVersion version = null;
            try {
                String versionString = extMod.getAutoDeployIndex();
                if (versionString != null) {
                    version = new DefaultArtifactVersion(versionString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return version;
        }

        @Override
        public int compare(ExtensionModule o1, ExtensionModule o2) {
            int r = 0;
            DefaultArtifactVersion v1 = this.parseAutoDeployIndex(o1);
            DefaultArtifactVersion v2 = this.parseAutoDeployIndex(o2);
            r = v1 == null && v2 == null ? 0 : (v1 != null && v2 == null ? -1 : (v1 == null && v2 != null ? 1 : v1.compareTo((ArtifactVersion)v2)));
            return r;
        }
    }

    private class DeployedModuleComparator
    implements Comparator<ModuleDeployment> {
        private DeployedModuleComparator() {
        }

        @Override
        public int compare(ModuleDeployment o1, ModuleDeployment o2) {
            return o1.getIndex() > o2.getIndex() ? 1 : (o1.getIndex() == o2.getIndex() ? 0 : -1);
        }
    }

    static interface ModuleDeploymentInvalidationMessage {
        public static final String TYPE = "module-deployment-invalidation";
    }
}

