/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.asual.lesscss.LessException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.LessForJavaCssThemeHandler;

public class HybridCssThemeHandler
extends LessForJavaCssThemeHandler {
    private static final Log logger = LogFactory.getLog(HybridCssThemeHandler.class);

    @Override
    public String processCssThemes(String path, StringBuilder cssContents) throws IOException {
        Object compiledCss = null;
        String initialProcessResults = super.processCssThemeTokens(path, cssContents);
        String lessVariables = this.getLessVariables();
        String fullCSS = lessVariables + initialProcessResults;
        try {
            compiledCss = this.engine.compile(fullCSS.toString());
        }
        catch (LessException e) {
            compiledCss = "/*" + this.logLessException((Exception)((Object)e), path) + "*/\n\n " + initialProcessResults;
        }
        catch (ClassCastException e) {
            compiledCss = "/*" + this.logLessException(e, path) + "*/\n\n " + initialProcessResults;
        }
        return compiledCss;
    }
}

