/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DependencyResource {
    private static Log logger = LogFactory.getLog(DependencyResource.class);
    private final String mimetype;
    private final byte[] content;
    private final String charset;
    private int length;

    public DependencyResource(String mimetype, String content, String charset) {
        this.mimetype = mimetype;
        this.charset = charset;
        this.length = content.length();
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream(this.length >> 2 > 32 ? this.length >> 2 : 32);
            GZIPOutputStream gzos = new GZIPOutputStream(bao);
            gzos.write(content.getBytes(charset));
            gzos.close();
            this.content = bao.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public byte[] getContent() {
        try {
            int len;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(this.content));
            byte[] buf = new byte[8192];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.length);
            while ((len = gzip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.close();
            gzip.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    int getStoredSize() {
        return this.content.length;
    }

    public String toString() {
        try {
            return new String(this.getContent(), this.charset);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            return "";
        }
    }
}

