/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.AbstractDependencyExtensibilityDirective;
import org.springframework.extensions.directives.OutputJavaScriptContentModelElement;
import org.springframework.extensions.directives.RelocateJavaScriptOutputDirectiveData;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.DiscardUnboundContentModelElementImpl;

public class RelocateJavaScriptOutputDirective
extends AbstractDependencyExtensibilityDirective {
    private static final Log logger = LogFactory.getLog(RelocateJavaScriptOutputDirective.class);

    public RelocateJavaScriptOutputDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        super.execute(env, params, loopVars, body);
        this.getModel().clearRelocatedContent("outputJavaScriptDirective", "outputJavaScript");
    }

    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) {
        ContentModelElement content = this.getModel().findContentModelElement("outputJavaScriptDirective");
        if (content == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"An attempt has been made to reloate a outputJavaScript before it has been processed. No relocation will occur");
            }
            content = new DiscardUnboundContentModelElementImpl();
        }
        return new RelocateJavaScriptOutputDirectiveData(id, action, target, body, env, (OutputJavaScriptContentModelElement)content);
    }
}

