/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Map;
import org.springframework.extensions.directives.AbstractDependencyExtensibilityDirective;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.types.TemplateInstance;

public class JavaScriptDependencyDirective
extends AbstractDependencyExtensibilityDirective {
    public static final String FORCE_AGGREGATED_OUTPUT_PARAM = "forceAggregation";

    public JavaScriptDependencyDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!(this.getModelObject() instanceof TemplateInstance) || !this.getRequestContext().isPassiveMode()) {
            DeferredContentTargetModelElement targetElement = this.getTargetElement();
            if (targetElement != null) {
                super.execute(env, params, loopVars, body);
            } else {
                this.addLegacyDependencyRequest(params);
            }
        }
    }

    protected void addLegacyDependencyRequest(Map params) throws TemplateModelException {
        String src = this.getStringProperty(params, "src", true);
        AbstractDependencyExtensibilityDirective.ProcessedDependency pd = this.processDependency(src);
        this.getRequestContext().addJSDependency(this.getUpdatedSrc(pd));
    }

    protected String getDependencySource(Map params) throws TemplateModelException {
        String src = this.getStringProperty(params, "src", true);
        return src;
    }

    protected DeferredContentTargetModelElement getTargetElement() {
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        return targetElement;
    }

    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        String src = this.getDependencySource(params);
        AbstractDependencyExtensibilityDirective.ProcessedDependency pd = this.processDependency(src);
        String group = this.getStringProperty(params, "group", false);
        return this.createDependencyDirectiveData(id, action, target, params, body, env, this.getUpdatedSrc(pd), group);
    }

    protected DependencyDirectiveData createDependencyDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env, String dependencyToAdd, String group) throws TemplateModelException {
        DeferredContentTargetModelElement targetElement = this.getTargetElement();
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, dependencyToAdd, group, this.getWebFrameworkConfig().isAggregateDependenciesEnabled(), targetElement);
        return directiveData;
    }
}

