/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateModelException;
import java.util.Map;
import org.springframework.extensions.directives.AbstractDependencyExtensibilityDirective;
import org.springframework.extensions.directives.CssDependencyDirectiveData;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;

public class CssDependencyDirective
extends JavaScriptDependencyDirective {
    public CssDependencyDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    @Override
    protected void addLegacyDependencyRequest(Map params) throws TemplateModelException {
        String src = this.getStringProperty(params, "href", true);
        String media = this.getStringProperty(params, "media", false);
        if (media == null) {
            media = "screen";
        }
        AbstractDependencyExtensibilityDirective.ProcessedDependency pd = this.processDependency(src);
        this.getRequestContext().addCssDependency(this.getUpdatedSrc(pd), media);
    }

    @Override
    protected String getDependencySource(Map params) throws TemplateModelException {
        String src = this.getStringProperty(params, "href", true);
        return src;
    }

    @Override
    protected DeferredContentTargetModelElement getTargetElement() {
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputCSSDependenciesDirective", "outputCSS");
        return targetElement;
    }

    @Override
    protected DependencyDirectiveData createDependencyDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env, String dependencyToAdd, String group) throws TemplateModelException {
        DeferredContentTargetModelElement targetElement = this.getTargetElement();
        String media = this.getStringProperty(params, "media", false);
        if (media == null) {
            media = "screen";
        }
        CssDependencyDirectiveData directiveData = new CssDependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, dependencyToAdd, group, media, this.getWebFrameworkConfig().isAggregateDependenciesEnabled(), targetElement);
        return directiveData;
    }
}

