/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.impl.AbstractFreeMarkerDirective;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.types.ComponentImpl;
import org.springframework.extensions.surf.util.XMLUtil;

public class AutoComponentRegionDirective
extends AbstractFreeMarkerDirective {
    public static final String DIRECTIVE_NAME = "autoComponentRegion";
    private RequestContext context = null;
    private RenderService renderService = null;

    public AutoComponentRegionDirective(String directiveName) {
        super(directiveName);
    }

    public void setRequestContext(RequestContext context) {
        this.context = context;
    }

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!this.context.isPassiveMode()) {
            String objectId = "tmpComponent";
            String objectTypeId = "component";
            String xml = "<" + objectTypeId + "></" + objectTypeId + ">";
            try {
                String uri = this.getStringProperty(params, "uri", true);
                if (!uri.equals("/")) {
                    Document document = XMLUtil.parse(xml);
                    ModelPersisterInfo info = new ModelPersisterInfo("tmp", "tmp", false);
                    ComponentImpl component = new ComponentImpl(objectId, info, document);
                    component.setURI(uri);
                    component.setURL(uri);
                    this.renderService.renderComponent(this.context, RenderFocus.BODY, component, null, true);
                }
            }
            catch (DocumentException e) {
                throw new TemplateException("Failed to parse generated XML: " + objectId, env);
            }
        }
    }
}

