/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;

public class AddInlineJavaScriptDirective
extends JavaScriptDependencyDirective {
    private static final Log logger = LogFactory.getLog(AddInlineJavaScriptDirective.class);

    public AddInlineJavaScriptDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    @Override
    protected void addLegacyDependencyRequest(Map params) throws TemplateModelException {
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        StringWriter o = new StringWriter();
        try {
            body.render((Writer)o);
        }
        catch (IOException e) {
            logger.error((Object)"The following exception occurred processing the body of an inline JavaScript request: ", (Throwable)e);
        }
        String dependency = ">>>" + o.toString();
        String group = this.getStringProperty(params, "group", false);
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, dependency, group, this.getWebFrameworkConfig().isAggregateDependenciesEnabled(), targetElement);
        return directiveData;
    }
}

