/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.render.AbstractProcessor;
import org.springframework.extensions.surf.render.ProcessorContext;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.SubComponent;
import org.springframework.extensions.surf.types.SurfBugData;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.LocalWebScriptContext;
import org.springframework.extensions.webscripts.LocalWebScriptRuntime;
import org.springframework.extensions.webscripts.LocalWebScriptRuntimeContainer;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.WebScript;

public class WebScriptProcessor
extends AbstractProcessor {
    public static final String WEBSCRIPT_SERVICE_SERVLET = "/service";
    static final String PARAM_WEBSCRIPT_ID = "_wsId";
    static final String PARAM_WEBSCRIPT_URL = "_wsUrl";
    private LocalWebScriptRuntimeContainer webScriptContainer;
    private ServerProperties serverProperties;
    private ConfigService configService;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
        Config config = this.configService.getConfig((Object)"Server");
        this.serverProperties = (ServerConfigElement)config.getConfigElement("server");
    }

    public Registry getRegistry() {
        return this.webScriptContainer.getRegistry();
    }

    public void setContainer(LocalWebScriptRuntimeContainer containerBean) {
        this.webScriptContainer = containerBean;
    }

    public LocalWebScriptRuntimeContainer getContainer() {
        return this.webScriptContainer;
    }

    @Override
    public void executeHeader(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        String url = this.getProperty(pc, "uri");
        if (object instanceof Component || object instanceof SubComponent) {
            Match match;
            SurfBugData component = (SurfBugData)((Object)object);
            if ((url = UriUtils.replaceTokens(url, context, null, null, "")).indexOf(63) != -1) {
                url = url.substring(0, url.indexOf(63));
            }
            if ((match = this.getRegistry().findWebScript(context.getRequestMethod(), url)) != null) {
                WebScript webScript;
                if (match.getKind() == Match.Kind.URI) {
                    match = this.getRegistry().findWebScript("GET", url);
                }
                if (match != null && (webScript = match.getWebScript()) != null) {
                    String path = webScript.getDescription().getId() + ".head";
                    component.setResolvedWebScript(webScript);
                    String validTemplatePath = this.getContainer().getTemplateProcessorRegistry().findValidTemplatePath(path);
                    if (validTemplatePath != null) {
                        ExtensibilityModel extModel = context.openExtensibilityModel();
                        extModel.addUnboundContent();
                        PrintWriter writer = null;
                        try {
                            writer = context.getResponse().getWriter();
                            HashMap<String, Object> model = new HashMap<String, Object>(32);
                            this.processorModelHelper.populateTemplateModel(context, model, object);
                            TemplateProcessor templateProcessor = this.getContainer().getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                            templateProcessor.process(validTemplatePath, model, (Writer)writer);
                            context.updateExtendingModuleDependencies(webScript.getDescription().getId(), model);
                            for (String moduleTemplatePath : context.getExtendingModuleFiles(validTemplatePath)) {
                                String modulePath = this.getContainer().getTemplateProcessorRegistry().findValidTemplatePath(moduleTemplatePath);
                                if (modulePath == null) continue;
                                templateProcessor.process(modulePath, model, (Writer)writer);
                            }
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new RendererExecutionException(uee);
                        }
                        catch (IOException ioe) {
                            throw new RendererExecutionException(ioe);
                        }
                        finally {
                            context.closeExtensibilityModel(extModel, writer);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBody(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        String uri = this.getProperty(pc, "uri");
        LocalWebScriptContext webScriptContext = new LocalWebScriptContext();
        webScriptContext.setTokens(WebScriptProcessor.buildArgs(context));
        String url = UriUtils.replaceTokens(uri, context, null, null, "");
        webScriptContext.setScriptUrl(url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63)));
        String requestPath = (String)((Object)context.getValue("requestPath"));
        if (requestPath == null) {
            requestPath = context.getContextPath();
        }
        if (object.getId().equals(context.getParameter(PARAM_WEBSCRIPT_ID))) {
            webScriptContext.setExecuteUrl(context.getParameter(PARAM_WEBSCRIPT_URL));
        } else {
            webScriptContext.setExecuteUrl(requestPath + WEBSCRIPT_SERVICE_SERVLET + url);
        }
        webScriptContext.setRuntimeContainer((RuntimeContainer)this.webScriptContainer);
        webScriptContext.setRequestContext(context);
        webScriptContext.setModelObject(object);
        try {
            LocalWebScriptRuntime runtime = new LocalWebScriptRuntime(context.getResponse().getWriter(), (RuntimeContainer)this.webScriptContainer, this.serverProperties, webScriptContext);
            if (context.getRequestMethod() != null) {
                Match match;
                String method = context.getRequestMethod();
                if (!"GET".equals(method) && (match = this.getRegistry().findWebScript(method, runtime.getScriptUrl())) != null && match.getKind() == Match.Kind.URI) {
                    method = "GET";
                }
                runtime.setScriptMethod(method);
            }
            this.webScriptContainer.bindRequestContext(context);
            this.webScriptContainer.bindModelObject(object);
            try {
                runtime.executeScript();
            }
            finally {
                this.webScriptContainer.unbindRequestContext();
                this.webScriptContainer.unbindModelObject();
            }
        }
        catch (IOException exc) {
            throw new RendererExecutionException("Unable to read back response from Web Script Runtime buffer", exc);
        }
    }

    @Override
    public boolean exists(ProcessorContext pc, ModelObject object) {
        RequestContext context = pc.getRequestContext();
        String uri = this.getProperty(pc, "uri");
        Match match = this.webScriptContainer.getRegistry().findWebScript(context.getRequestMethod(), uri);
        return match != null;
    }

    private static Map<String, String> buildArgs(RequestContext context) {
        return context.getParameters();
    }
}

