/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.Serializable;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptResourceContent;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptResource
extends ScriptBase {
    private ScriptResourceContent payloadContent = null;
    private ScriptResourceContent payloadMetadata = null;
    private final Resource resource;

    public ScriptResource(RequestContext context, Resource resource) {
        super(context);
        this.resource = resource;
    }

    @Override
    protected ScriptableMap<String, Serializable> buildProperties() {
        return null;
    }

    public String getId() {
        return this.resource.getResourceId();
    }

    public String getProtocolId() {
        return this.resource.getProtocolId();
    }

    public String getEndpointId() {
        return this.resource.getEndpointId();
    }

    public String getObjectId() {
        return this.resource.getObjectId();
    }

    public String getObjectTypeId() {
        return this.resource.getObjectTypeId();
    }

    public String getName() {
        return this.resource.getName();
    }

    public synchronized ScriptResourceContent getContent() {
        if (this.payloadContent == null) {
            try {
                this.payloadContent = new ScriptResourceContent(this.context, this, this.resource.getContent());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.payloadContent;
    }

    public String getContentUrl() {
        return this.resource.getContentURL();
    }

    public synchronized ScriptResourceContent getMetadata() {
        if (this.payloadMetadata == null) {
            try {
                this.payloadMetadata = new ScriptResourceContent(this.context, this, this.resource.getMetadata());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.payloadMetadata;
    }

    public String getMetadataUrl() {
        return this.resource.getMetadataURL();
    }

    public boolean getIsContainer() {
        return this.resource.isContainer();
    }
}

