/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.site.ThemeUtil;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptLinkBuilder;
import org.springframework.extensions.webscripts.ScriptModelObject;
import org.springframework.extensions.webscripts.ScriptResource;
import org.springframework.extensions.webscripts.ScriptUser;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.springframework.extensions.webscripts.ScriptableWrappedMap;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.connector.User;

@ScriptClass(help="Render context for the current rendering object", types={ScriptClassType.JavaScriptRootObject, ScriptClassType.TemplateRootObject})
public final class ScriptRenderContext
extends ScriptBase {
    private ScriptResource scriptResource = null;
    private ScriptModelObject scriptPageObject = null;
    private ScriptModelObject scriptTemplateObject = null;
    private ScriptModelObject scriptThemeObject = null;
    private ScriptModelObject scriptRootPageObject = null;
    private ScriptUser scriptUser = null;
    private ScriptLinkBuilder scriptLinkBuilder = null;
    private final RequestContext renderContext;
    protected ScriptableMap<String, Serializable> parameters;
    protected ScriptableMap<String, Serializable> attributes;
    protected ScriptableMap<String, Serializable> headers;

    public ScriptRenderContext(RequestContext context) {
        super(context);
        this.renderContext = context;
    }

    protected ScriptableMap buildProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableWrappedMap(this.context.getValuesMap());
            this.properties.putAll(this.context.getParameters());
        }
        return this.properties;
    }

    public void setValue(String key, Object value) {
        this.renderContext.setValue(key, (Serializable)ScriptValueConverter.unwrapValue((Object)value));
    }

    @ScriptMethod(help="Gets the id of the currently rendering content resource", output="The id of the content resource or null if none")
    public String getContentId() {
        return this.context.getCurrentObjectId();
    }

    @ScriptMethod(help="Gets the currently rendering content resource", output="The currently rendering ScriptResource or null if none")
    public synchronized ScriptResource getResource() {
        Resource resource;
        if (this.scriptResource == null && (resource = this.context.getCurrentObject()) != null) {
            this.scriptResource = new ScriptResource(this.context, resource);
        }
        return this.scriptResource;
    }

    @ScriptMethod(help="Gets the requested format id")
    public String getFormatId() {
        return this.context.getFormatId();
    }

    @ScriptMethod(help="Gets the id of the request context")
    public String getId() {
        return this.context.getId();
    }

    @ScriptMethod(help="Gets the id of the currently rendering page.\nReturns null if a page is not being rendered.")
    public String getPageId() {
        return this.context.getPageId();
    }

    @ScriptMethod(help="Gets the currently rendering page.", output="The ScriptModelObject for the Page or null if a page is not being rendered.")
    public ScriptModelObject getPage() {
        Page page;
        if (this.scriptPageObject == null && (page = this.context.getPage()) != null) {
            this.scriptPageObject = new ScriptModelObject(this.context, page);
        }
        return this.scriptPageObject;
    }

    @ScriptMethod(help="Gets the id of the currently rendering template.\nReturns null if a template is not being rendered.")
    public String getTemplateId() {
        return this.context.getTemplateId();
    }

    @ScriptMethod(help="Gets the currently rendering template.", output="The ScriptModelObject for the Template or null if a template is not being rendered.")
    public ScriptModelObject getTemplate() {
        TemplateInstance template;
        if (this.scriptTemplateObject == null && (template = this.context.getTemplate()) != null) {
            this.scriptTemplateObject = new ScriptModelObject(this.context, template);
        }
        return this.scriptTemplateObject;
    }

    @ScriptMethod(help="Gets the currently rendering theme id.")
    public String getThemeId() {
        return this.context.getThemeId();
    }

    @ScriptMethod(help="Gets the currently rendering theme.", output="The ScriptModelObject for the Theme or null if a theme is not being rendered.")
    public ScriptModelObject getTheme() {
        Theme theme;
        if (this.scriptThemeObject == null && (theme = this.context.getTheme()) != null) {
            this.scriptThemeObject = new ScriptModelObject(this.context, theme);
        }
        return this.scriptThemeObject;
    }

    @ScriptMethod(help="Sets the theme for the current user session by providing the theme id.")
    public void setThemeId(String themeId) {
        ThemeUtil.setCurrentThemeId(this.renderContext, themeId);
    }

    @ScriptMethod(help="Gets the site configuration.", output="The ScriptModelObject for the site configuration or null if a site configuration is not set up.")
    public ScriptModelObject getSiteConfiguration() {
        return new ScriptModelObject(this.renderContext, this.renderContext.getSiteConfiguration());
    }

    @ScriptMethod(help="Gets the user object.", output="The ScriptUser for the current user or null if a user is not logged in.")
    public ScriptUser getUser() {
        User user;
        if (this.scriptUser == null && (user = this.context.getUser()) != null) {
            this.scriptUser = new ScriptUser(this.context, user);
        }
        return this.scriptUser;
    }

    @ScriptMethod(help="Returns whether the current user is authenticated.")
    public boolean getAuthenticated() {
        HttpServletRequest request = ServletUtil.getRequest();
        return AuthenticationUtil.isAuthenticated(request);
    }

    @ScriptMethod(help="Returns whether the current user is externally authenticated.")
    public boolean getExternalAuthentication() {
        HttpServletRequest request = ServletUtil.getRequest();
        return AuthenticationUtil.isExternalAuthentication(request);
    }

    @ScriptMethod(help="Returns whether the current user is AIMS authenticated.")
    public boolean getAimsAuthentication() {
        HttpServletRequest request = ServletUtil.getRequest();
        return AuthenticationUtil.isAimsAuthentication(request);
    }

    @ScriptMethod(help="Returns the ScriptLinkBuilder instance for the current request.")
    public ScriptLinkBuilder getLinkBuilder() {
        if (this.scriptLinkBuilder == null) {
            this.scriptLinkBuilder = new ScriptLinkBuilder(this.context);
        }
        return this.scriptLinkBuilder;
    }

    public String getWebsiteTitle() {
        return this.context.getWebsiteTitle();
    }

    public String getUri() {
        return this.context.getUri();
    }

    @ScriptMethod(help="Gets the root page for the site.", output="The ScriptModelObject for the root page.")
    public ScriptModelObject getRootPage() {
        Page rootPage;
        if (this.scriptRootPageObject == null && (rootPage = this.context.getRootPage()) != null) {
            this.scriptRootPageObject = new ScriptModelObject(this.context, rootPage);
        }
        return this.scriptRootPageObject;
    }

    public String getPreviewWebappId() {
        return this.context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getWebappId();
    }

    public String getPreviewStoreId() {
        return this.context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getStoreId();
    }

    public String getPreviewUserId() {
        return this.context.getServiceRegistry().getObjectPersistenceService().getPersistenceContext().getUserId();
    }

    public ScriptResource loadResource(String resourceId) {
        ScriptResource scriptResource = null;
        try {
            Resource resource = this.context.getServiceRegistry().getResourceService().getResource(resourceId);
            if (resource != null) {
                scriptResource = new ScriptResource(this.context, resource);
            }
        }
        catch (ResourceLoaderException rle) {
            rle.printStackTrace();
        }
        return scriptResource;
    }

    public ScriptResource loadResource(String protocolId, String endpointId, String objectId) {
        ScriptResource scriptResource = null;
        try {
            Resource resource = this.context.getServiceRegistry().getResourceService().getResource(protocolId, endpointId, objectId);
            if (resource != null) {
                scriptResource = new ScriptResource(this.context, resource);
            }
        }
        catch (ResourceLoaderException rle) {
            rle.printStackTrace();
        }
        return scriptResource;
    }

    @ScriptMethod(help="A key/value map of parameters in the incoming request.")
    public ScriptableMap getParameters() {
        if (this.parameters == null) {
            this.parameters = new ScriptableWrappedMap(this.context.getParameters());
        }
        return this.parameters;
    }

    public ScriptableMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ScriptableWrappedMap(this.context.getAttributes());
        }
        return this.attributes;
    }

    public ScriptableMap getHeaders() {
        if (this.headers == null) {
            this.headers = new ScriptableWrappedMap(this.context.getHeaders());
        }
        return this.headers;
    }
}

