/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class MessagesWebScript
extends AbstractWebScript {
    protected final Cache cache;
    protected final Map<String, String> messages = new HashMap<String, String>(8);
    protected final Map<String, String> localeToChecksum = new HashMap<String, String>(8);
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReadWriteLock checksumLock = new ReentrantReadWriteLock();
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private DependencyHandler dependencyHandler;

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public MessagesWebScript() {
        this.cache = new Cache();
        this.cache.setNeverCache(false);
        this.cache.setMustRevalidate(true);
        this.cache.setLastModified(new Date());
        this.cache.setMaxAge(Long.valueOf(6000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String result;
        block9: {
            res.setContentType(Format.JAVASCRIPT.mimetype() + ";charset=UTF-8");
            res.setCache(this.cache);
            String locale = req.getParameter("locale");
            if (locale == null || locale.length() == 0) {
                throw new WebScriptException("Locale parameter is mandatory.");
            }
            String cacheKey = this.generateCacheKey(locale);
            result = "";
            this.cacheLock.readLock().lock();
            try {
                result = this.messages.get(cacheKey);
                if (result != null) break block9;
                this.cacheLock.readLock().unlock();
                this.cacheLock.writeLock().lock();
                try {
                    if (this.webFrameworkConfigElement != null && this.webFrameworkConfigElement.useChecksumDependencies()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.getMessagesPrefix(req, res, locale));
                        String messages = this.generateMessages(locale);
                        sb.append(messages);
                        sb.append(this.getMessagesSuffix(req, res, locale));
                        result = sb.toString();
                    } else {
                        result = this.generateMessages(req, res, locale);
                    }
                    this.messages.put(cacheKey, result);
                }
                finally {
                    this.cacheLock.readLock().lock();
                    this.cacheLock.writeLock().unlock();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        res.getWriter().write(result);
        res.getWriter().flush();
        res.getWriter().close();
    }

    public String generateCacheKey(String locale) {
        String protocol = ThreadLocalRequestContext.getRequestContext().getRequestScheme();
        String cacheKey = protocol + "_" + locale;
        return cacheKey;
    }

    public String generateCachedLocaleChecksum(String locale) {
        String cacheKey = this.generateCacheKey(locale);
        String checksum = this.getCachedLocaleChecksum(cacheKey);
        if (checksum == null) {
            this.generateMessages(locale);
            checksum = this.getCachedLocaleChecksum(cacheKey);
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedLocaleChecksum(String locale) {
        String checksum = null;
        this.checksumLock.readLock().lock();
        try {
            String cacheKey = this.generateCacheKey(locale);
            checksum = this.localeToChecksum.get(cacheKey);
        }
        finally {
            this.checksumLock.readLock().unlock();
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedLocaleChecksum(String locale, String checksum) {
        try {
            this.checksumLock.writeLock().lock();
            String cacheKey = this.generateCacheKey(locale);
            this.localeToChecksum.put(cacheKey, checksum);
        }
        finally {
            this.checksumLock.writeLock().unlock();
        }
    }

    protected String getMessagesPrefix(WebScriptRequest req, WebScriptResponse res, String locale) throws IOException {
        return "if (typeof SpringSurf == \"undefined\" || !SpringSurf) {var SpringSurf = {};}\r\nSpringSurf.messages = SpringSurf.messages || {global: null, scope: {}}\r\nSpringSurf.messages.global = ";
    }

    protected String getMessagesSuffix(WebScriptRequest req, WebScriptResponse res, String locale) throws IOException {
        return ";\r\n";
    }

    protected final String generateMessages(String locale) {
        Object messages;
        StringBuilderWriter writer = new StringBuilderWriter(8192);
        JSONWriter out = new JSONWriter((Writer)writer);
        try {
            out.startObject();
            messages = I18NUtil.getAllMessages((Locale)I18NUtil.parseLocale((String)locale));
            for (Map.Entry entry : messages.entrySet()) {
                out.writeValue((String)entry.getKey(), (String)entry.getValue());
            }
            out.endObject();
        }
        catch (IOException jsonErr) {
            throw new WebScriptException("Error building messages response.", (Throwable)jsonErr);
        }
        messages = writer.toString();
        if (this.webFrameworkConfigElement.useChecksumDependencies()) {
            String checksum = this.dependencyHandler.generateCheckSum((String)messages);
            String cacheKey = this.generateCacheKey(locale);
            this.setCachedLocaleChecksum(cacheKey, checksum);
        }
        return messages;
    }

    protected String generateMessages(WebScriptRequest req, WebScriptResponse res, String locale) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(8192);
        writer.write("if (typeof SpringSurf == \"undefined\" || !SpringSurf) {var SpringSurf = {};}\r\n");
        writer.write("SpringSurf.messages = SpringSurf.messages || {global: null, scope: {}}\r\n");
        writer.write("SpringSurf.messages.global = ");
        JSONWriter out = new JSONWriter((Writer)writer);
        try {
            out.startObject();
            Map messages = I18NUtil.getAllMessages((Locale)I18NUtil.parseLocale((String)locale));
            for (Map.Entry entry : messages.entrySet()) {
                out.writeValue((String)entry.getKey(), (String)entry.getValue());
            }
            out.endObject();
        }
        catch (IOException jsonErr) {
            throw new WebScriptException("Error building messages response.", (Throwable)jsonErr);
        }
        writer.write(";\r\n");
        return writer.toString();
    }
}

