/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class BasicHttpAuthenticatorFactory
implements ServletAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(BasicHttpAuthenticatorFactory.class);
    private ConnectorService connectorService;
    private String endpointId;
    private boolean delegate = false;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new BasicHttpAuthenticator(req, res);
    }

    public class BasicHttpAuthenticator
    implements Authenticator {
        private WebScriptServletRequest servletReq;
        private WebScriptServletResponse servletRes;
        private String authorization;
        private String ticket;

        public BasicHttpAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res) {
            this.servletReq = req;
            this.servletRes = res;
            HttpServletRequest httpReq = this.servletReq.getHttpServletRequest();
            this.authorization = httpReq.getHeader("Authorization");
            this.ticket = httpReq.getParameter("alf_ticket");
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authorized = false;
            HttpServletRequest req = this.servletReq.getHttpServletRequest();
            HttpServletResponse res = this.servletRes.getHttpServletResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HTTP Authorization provided: " + (this.authorization != null && this.authorization.length() != 0)));
            }
            if (this.authorization != null && this.authorization.length() != 0) {
                String[] authorizationParts = this.authorization.split(" ");
                if (!authorizationParts[0].equalsIgnoreCase("basic")) {
                    throw new WebScriptException("Authorization '" + authorizationParts[0] + "' not supported.");
                }
                String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
                String[] parts = decodedAuthorisation.split(":");
                if (parts.length == 2) {
                    String username = parts[0];
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authenticating (BASIC HTTP) user " + parts[0]));
                    }
                    try {
                        HttpSession session = req.getSession();
                        CredentialsImpl credentials = new CredentialsImpl(BasicHttpAuthenticatorFactory.this.endpointId);
                        credentials.setProperty("cleartextUsername", (Object)username);
                        credentials.setProperty("cleartextPassword", (Object)parts[1]);
                        CredentialVault vault = BasicHttpAuthenticatorFactory.this.connectorService.getCredentialVault(session, username);
                        vault.store((Credentials)credentials);
                        if (BasicHttpAuthenticatorFactory.this.delegate) {
                            session.setAttribute("_alf_USER_ID", (Object)username);
                            authorized = true;
                        } else {
                            Connector connector = BasicHttpAuthenticatorFactory.this.connectorService.getConnector(BasicHttpAuthenticatorFactory.this.endpointId, username, session);
                            Response response = connector.call("/touch");
                            boolean bl = authorized = response.getStatus().getCode() == 200;
                            if (Description.RequiredAuthentication.admin == required) {
                                RequestContext rc = ThreadLocalRequestContext.getRequestContext();
                                UserFactory userFactory = rc.getServiceRegistry().getUserFactory();
                                User user = userFactory.loadUser(rc, username, BasicHttpAuthenticatorFactory.this.endpointId);
                                authorized = user.isAdmin();
                            }
                        }
                    }
                    catch (Throwable err) {
                        logger.warn((Object)("Failed during authorization: " + err.getMessage()), err);
                    }
                }
            }
            if (!authorized) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Requesting authorization credentials");
                }
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
            }
            return authorized;
        }

        public boolean emptyCredentials() {
            return !(this.ticket != null && this.ticket.length() != 0 || this.authorization != null && this.authorization.length() != 0);
        }
    }
}

