/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.BaseElement;
import org.dom4j.tree.DefaultDocument;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.SubComponentEvaluation;
import org.springframework.extensions.surf.extensibility.XMLHelper;
import org.springframework.extensions.surf.extensibility.impl.DefaultSubComponentEvaluation;
import org.springframework.extensions.surf.render.AbstractRenderableModelObject;
import org.springframework.extensions.surf.types.SurfBugData;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.WebScript;

public class SubComponent
extends AbstractRenderableModelObject
implements Comparable<SubComponent>,
SurfBugData {
    private static final Log logger = LogFactory.getLog(SubComponent.class);
    private static final long serialVersionUID = -7181077392520052355L;
    public static final String SUB_COMPONENT_TYPE = "sub-component";
    private String baseId = null;
    private String parentId = null;
    private String displayId = null;
    private Integer index = null;
    private Integer baseIndex = null;
    private String uri = null;
    private String baseUri = null;
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private String processorId = null;
    private String baseProcessorId = null;
    private String componentTypeId = null;
    private String baseComponentTypeId = null;
    private int lastEvaluationMergeIndex = 0;
    private List<SubComponentEvaluation> evaluations = new ArrayList<SubComponentEvaluation>();
    private List<SubComponentEvaluation> baseEvaluations = new ArrayList<SubComponentEvaluation>();
    private WebScript resolvedWebScript;

    public SubComponent(String id, String parentId) {
        super(parentId + "#" + id, null, (Document)new DefaultDocument(new BaseElement("generated-document").addAttribute("component", parentId).addAttribute(SUB_COMPONENT_TYPE, id)));
        this.baseId = id;
        this.parentId = parentId;
        this.displayId = "Component: " + parentId + ", Sub-Component: " + id;
    }

    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String toString() {
        return this.displayId;
    }

    public Integer getIndex() {
        return this.index;
    }

    private void setIndex(Integer index) {
        this.index = index;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.baseUri = uri;
    }

    @Override
    public String getProcessorId() {
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
        this.baseProcessorId = processorId;
    }

    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public void setComponentTypeId(String componentTypeId) {
        this.componentTypeId = componentTypeId;
        this.baseComponentTypeId = componentTypeId;
    }

    public void mergeExtension(SubComponent ext) {
        this.index = ext.index != null ? ext.index : this.index;
        this.uri = ext.uri != null ? ext.uri : this.uri;
        for (Map.Entry<String, String> property : ext.defaultProperties.entrySet()) {
            this.defaultProperties.put(property.getKey(), property.getValue());
        }
        this.evaluations.addAll(this.lastEvaluationMergeIndex, ext.getEvaluations());
        this.lastEvaluationMergeIndex += ext.getEvaluations().size();
    }

    public SubComponent clone() {
        SubComponent clone = new SubComponent(this.baseId, this.parentId);
        clone.setIndex(this.baseIndex != null ? new Integer(this.baseIndex) : null);
        clone.setUri(this.baseUri);
        clone.getEvaluations().addAll(this.baseEvaluations);
        clone.setProcessorId(this.baseProcessorId);
        clone.setComponentTypeId(this.baseComponentTypeId);
        for (Map.Entry<String, String> property : this.defaultProperties.entrySet()) {
            clone.defaultProperties.put(property.getKey(), property.getValue());
        }
        clone.setAllProperties(this.getModelProperties(), this.getCustomProperties());
        return clone;
    }

    public List<SubComponentEvaluation> getEvaluations() {
        return this.evaluations;
    }

    public RenderData determineURI(RequestContext context, ApplicationContext applicationContext) {
        SubComponentEvaluation successfulEvaluation = null;
        String uri = this.uri;
        boolean shouldRender = true;
        HashMap<String, Serializable> evaluatedProps = new HashMap<String, Serializable>();
        evaluatedProps.putAll(this.defaultProperties);
        if (this.evaluations != null && this.evaluations.isEmpty()) {
            if (this.uri != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No <evaluations> are available for <sub-component> '" + this.displayId + "' - using default URI: " + this.uri));
                }
                uri = this.uri;
            } else if (this.componentTypeId == null && this.processorId == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("There are no <evaluations> for <sub-component> '" + this.displayId + "' and it has not been configured with a uri. Therefore the <sub-component> cannot be rendered"));
                }
                shouldRender = false;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing <evaluations> for <sub-component> '" + this.displayId + "'"));
            }
            boolean evaluationPassed = false;
            for (SubComponentEvaluation evaluation : this.evaluations) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Evaluating <sub-component> '" + this.displayId + "' using evaluation '" + evaluation.getId() + "'"));
                }
                if (!evaluation.evaluate(context, applicationContext)) continue;
                if (evaluation.renderIfEvaluated()) {
                    uri = evaluation.getUri();
                    if (uri == null) {
                        if (this.uri == null) {
                            if (logger.isErrorEnabled()) {
                                logger.error((Object)("Neither <evaluation> '" + evaluation.getId() + "' nor <sub-component> '" + this.displayId + "' have not been configured with a uri. Therefore the <sub-component> cannot be rendered"));
                            }
                        } else {
                            uri = this.uri;
                        }
                    }
                    evaluatedProps.putAll(evaluation.getProperties());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("<evaluation> '" + evaluation.getId() + "' has passed indicating that <sub-component> '" + this.displayId + "' should not be rendered"));
                    }
                    uri = null;
                    shouldRender = false;
                }
                successfulEvaluation = evaluation;
                evaluationPassed = true;
                break;
            }
            if (uri == null && !evaluationPassed) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No evaluations passed for <sub-component> '" + this.displayId + "' and it has no default URI so it will not be rendered"));
                }
                shouldRender = false;
            }
        }
        for (Map.Entry prop : evaluatedProps.entrySet()) {
            evaluatedProps.put((String)prop.getKey(), (Serializable)((Object)UriUtils.replaceTokens(((Serializable)prop.getValue()).toString(), context, null, null, "")));
        }
        RenderData data = new RenderData(shouldRender, uri, evaluatedProps, successfulEvaluation);
        return data;
    }

    @Override
    public int compareTo(SubComponent that) {
        int thisIndex = 50;
        if (this.index != null) {
            thisIndex = this.index;
        }
        int thatIndex = 50;
        if (that.index != null) {
            thatIndex = that.index;
        }
        return thisIndex - thatIndex;
    }

    @Override
    public String getTypeId() {
        return SUB_COMPONENT_TYPE;
    }

    @Override
    public void setResolvedWebScript(WebScript webScript) {
        this.resolvedWebScript = webScript;
    }

    @Override
    public WebScript getResolvedWebScript() {
        return this.resolvedWebScript;
    }

    public void setAllProperties(Map<String, Serializable> standardProps, Map<String, Serializable> customProps) {
        this.modelProperties = standardProps;
        this.customProperties = customProps;
    }

    public void applyConfiguration(Element componentEl) {
        Element evaluationsEl;
        Element uriEl;
        block18: {
            String index = componentEl.attributeValue("index");
            if (index != null) {
                try {
                    this.index = Integer.parseInt(index);
                    this.baseIndex = Integer.parseInt(index);
                }
                catch (NumberFormatException e) {
                    if (!logger.isErrorEnabled()) break block18;
                    logger.error((Object)("Invalid index'" + index + "' defined for sub-component'" + this.getId() + "'"));
                }
            }
        }
        if ((uriEl = componentEl.element("uri")) != null) {
            this.uri = uriEl.getTextTrim();
        } else {
            Element evalutionUrlEl = componentEl.element("url");
            if (evalutionUrlEl != null) {
                this.uri = evalutionUrlEl.getTextTrim();
            }
        }
        this.baseUri = this.uri;
        Element propertiesEl = componentEl.element("properties");
        if (propertiesEl != null) {
            List propertiesList = propertiesEl.elements();
            for (Element property : propertiesList) {
                this.defaultProperties.put(property.getName(), property.getTextTrim());
            }
        }
        if ((evaluationsEl = componentEl.element("evaluations")) != null) {
            List evaluationList = evaluationsEl.elements("evaluation");
            for (Element evaluationEl : evaluationList) {
                Element evaluatorsEl;
                String renderIfEvaluatedStr;
                String id = evaluationEl.attributeValue("id");
                if (id == null) {
                    id = "";
                }
                if ((renderIfEvaluatedStr = evaluationEl.attributeValue("render")) == null) {
                    renderIfEvaluatedStr = XMLHelper.getStringData((String)"render", (Element)evaluationEl, (boolean)false);
                }
                boolean renderIfEvaluated = renderIfEvaluatedStr == null || Boolean.parseBoolean(renderIfEvaluatedStr);
                DefaultSubComponentEvaluation dcee = new DefaultSubComponentEvaluation(id, renderIfEvaluated);
                this.evaluations.add(dcee);
                this.baseEvaluations.add(dcee);
                this.componentTypeId = null;
                this.processorId = null;
                Element evalutionUriEl = evaluationEl.element("uri");
                if (evalutionUriEl != null) {
                    dcee.setUri(evalutionUriEl.getTextTrim());
                } else {
                    Element evalutionUrlEl = evaluationEl.element("url");
                    if (evalutionUrlEl != null) {
                        dcee.setUri(evalutionUrlEl.getTextTrim());
                    }
                }
                Element evalPropertiesEl = evaluationEl.element("properties");
                if (evalPropertiesEl != null) {
                    List propertiesList = evalPropertiesEl.elements();
                    for (Element property : propertiesList) {
                        dcee.addProperty(property.getName(), property.getTextTrim());
                    }
                }
                if ((evaluatorsEl = evaluationEl.element("evaluators")) == null) continue;
                List evaluatorList = evaluatorsEl.elements("evaluator");
                for (Element evaluatorEl : evaluatorList) {
                    String evaluatorType = evaluatorEl.attributeValue("type");
                    if (evaluatorType == null) continue;
                    Map evaluatorParams = XMLHelper.getProperties((String)"params", (Element)evaluatorEl);
                    boolean negate = XMLHelper.getBooleanAttribute((String)"negate", (Element)evaluatorEl, (boolean)false);
                    dcee.addEvaluator(evaluatorType, evaluatorParams, negate);
                }
            }
        }
    }

    public class RenderData {
        private boolean shouldRender = false;
        private String uri = null;
        private Map<String, Serializable> properties = null;
        private SubComponentEvaluation evaluation = null;

        public RenderData(boolean shouldRender, String uri, Map<String, Serializable> properties, SubComponentEvaluation evaluation) {
            this.shouldRender = shouldRender;
            this.uri = uri;
            this.properties = properties;
            this.evaluation = evaluation;
        }

        public boolean shouldRender() {
            return this.shouldRender;
        }

        public String getUri() {
            return this.uri;
        }

        public Map<String, Serializable> getProperties() {
            return this.properties;
        }

        public SubComponentEvaluation getEvaluation() {
            return this.evaluation;
        }

        public String toString() {
            return "Should render: " + this.shouldRender + ", URI: " + this.uri;
        }
    }
}

