/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.BaseElement;
import org.dom4j.tree.DefaultDocument;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.extensibility.BasicExtensionModule;
import org.springframework.extensions.surf.extensibility.XMLHelper;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.types.AdvancedComponent;
import org.springframework.extensions.surf.types.AdvancedComponentImpl;

public class ExtensionModule
extends BasicExtensionModule {
    private static final Log logger = LogFactory.getLog(ExtensionModule.class);
    private ModelPersisterInfo key = null;
    public HashMap<String, AdvancedComponent> advancedComponents = new HashMap();

    public ModelPersisterInfo getKeyPath() {
        return this.key;
    }

    public ExtensionModule(Element element, ModelPersisterInfo key) {
        super(element);
        this.key = key;
        if (this.getId() != null) {
            List componentsList = element.elements("components");
            for (Element componentsEl : componentsList) {
                List componentList = componentsEl.elements("component");
                for (Element componentEl : componentList) {
                    String componentId = componentEl.attributeValue("id");
                    if (componentId == null) {
                        String scope = XMLHelper.getStringData((String)"scope", (Element)componentEl, (boolean)false);
                        String region = XMLHelper.getStringData((String)"region-id", (Element)componentEl, (boolean)false);
                        String source = XMLHelper.getStringData((String)"source-id", (Element)componentEl, (boolean)false);
                        componentId = RenderUtil.generateComponentId(scope, region, source);
                    }
                    if (componentId != null) {
                        AdvancedComponentImpl advancedComponent = new AdvancedComponentImpl(componentId, this.key, (Document)new DefaultDocument((Element)new BaseElement("dummy")));
                        advancedComponent.applyConfig(componentEl);
                        this.advancedComponents.put(componentId, advancedComponent);
                        continue;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)("A <component> element was found with no identification in <module> '" + this.getId() + "'"));
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A <module> was found with no identification");
        }
    }

    public HashMap<String, AdvancedComponent> getAdvancedComponents() {
        return this.advancedComponents;
    }
}

