/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AlfrescoUser;
import org.springframework.extensions.surf.support.AlfrescoUserFactory;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;

public class Alfresco32UserFactory
extends AlfrescoUserFactory {
    @Override
    public User loadUser(RequestContext context, String userId, String endpointId) throws UserFactoryException {
        if (endpointId == null) {
            endpointId = "alfresco";
        }
        AlfrescoUser user = null;
        try {
            String uri;
            HttpSession session;
            Connector connector;
            Response response;
            String currentUserId = context.getUserId();
            if (currentUserId == null) {
                currentUserId = userId;
            }
            if (200 != (response = (connector = this.frameworkUtils.getConnector(session = ServletUtil.getSession(), currentUserId, endpointId)).call(uri = "/webframework/content/metadata?user=" + URLEncoder.encode((String)userId))).getStatus().getCode()) {
                throw new UserFactoryException("Unable to create user - failed to retrieve user metadata: " + response.getStatus().getMessage(), (Exception)response.getStatus().getException());
            }
            JSONObject json = new JSONObject(response.getResponse());
            user = this.buildAlfrescoUser(json);
        }
        catch (Exception ex) {
            throw new UserFactoryException("Unable to retrieve user from repository", ex);
        }
        return user;
    }

    @Override
    protected AlfrescoUser buildAlfrescoUser(JSONObject json) throws JSONException, UserFactoryException {
        JSONObject properties = json.getJSONObject("properties");
        HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>(1, 1.0f);
        capabilities.put("isGuest", Boolean.TRUE);
        return this.constructAlfrescoUser(json, properties, capabilities, null);
    }
}

