/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.processor;

import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.processor.JSScriptProcessor;

public class JSScriptWithTokensProcessor
extends JSScriptProcessor {
    private WebFrameworkConfigElement webFrameworkConfigElement;

    public WebFrameworkConfigElement getWebFrameworkConfigElement() {
        return this.webFrameworkConfigElement;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public String getAikauVersion() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        String aikauVersion = null;
        ScriptConfigModel config = rc.getExtendedScriptConfigModel(null);
        Map configs = (Map)config.getScoped().get("WebFramework");
        if (configs != null) {
            WebFrameworkConfigElement wfce = (WebFrameworkConfigElement)configs.get("web-framework");
            aikauVersion = wfce.getAikauVersion();
        } else {
            aikauVersion = this.getWebFrameworkConfigElement().getAikauVersion();
        }
        return aikauVersion;
    }

    public String loadScriptResource(String resource) {
        String aikauVersion = this.getAikauVersion();
        if (aikauVersion != null) {
            resource = resource.replaceAll("\\{aikauVersion\\}", aikauVersion);
        }
        return super.loadScriptResource(resource);
    }
}

