/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyResource;
import org.springframework.extensions.surf.DojoDependencyHandler;

public class ResourceController
extends org.springframework.extensions.webscripts.servlet.mvc.ResourceController {
    public static final String HTTP_HEADER_EXPIRES = "Expires";
    public static final String HTTP_HEADER_FAR_FUTURE_EXPIRES_VALUE = "Sun, 17-Jan-2038 19:14:07 GMT";
    private DependencyHandler dependencyHandler;
    private DependencyAggregator dependencyAggregator;
    private DojoDependencyHandler dojoDependencyHandler;
    private WebFrameworkConfigElement webframeworkConfigElement;
    public static final String FORWARD_SLASH = "/";
    public static final String FULL_STOP = ".";
    public static final String DOUBLE_FULL_STOP = "..";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String SINGLE_QUOTE = "'";

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public void setWebframeworkConfigElement(WebFrameworkConfigElement webframeworkConfigElement) {
        this.webframeworkConfigElement = webframeworkConfigElement;
    }

    public boolean dispatchResource(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream in;
        String aggregatedDojoResource;
        boolean resolved = false;
        if (!this.isAllowedResourcePath(path)) {
            response.setStatus(403);
            return true;
        }
        DependencyResource resource = this.dependencyAggregator.getCachedDependencyResource(path);
        if (resource != null) {
            byte[] bytes = resource.getContent();
            this.applyHeaders(path, response, bytes.length, 0L);
            ByteArrayInputStream in2 = new ByteArrayInputStream(bytes);
            this.copyStream(in2, (OutputStream)response.getOutputStream());
            resolved = true;
        }
        if (!resolved && this.webframeworkConfigElement.isDojoEnabled() && (aggregatedDojoResource = this.dojoDependencyHandler.getCachedResource(path)) != null) {
            byte[] bytes = aggregatedDojoResource.getBytes(this.dependencyHandler.getCharset());
            this.applyHeaders(path, response, bytes.length, 0L);
            ByteArrayInputStream in3 = new ByteArrayInputStream(bytes);
            this.copyStream(in3, (OutputStream)response.getOutputStream());
            resolved = true;
        }
        if (!resolved && (in = this.dependencyHandler.getResourceInputStream(path)) != null) {
            this.applyHeaders(path, response, in.available(), 0L);
            this.copyStream(in, (OutputStream)response.getOutputStream());
            resolved = true;
        }
        if (!resolved) {
            resolved = super.dispatchResource(path, request, response);
        }
        return resolved;
    }

    public String getPath(String sourcePath, String dependencyPath) {
        String pathPrefix = sourcePath.substring(0, sourcePath.lastIndexOf(FORWARD_SLASH));
        if (dependencyPath.startsWith(DOUBLE_QUOTES) || dependencyPath.startsWith(SINGLE_QUOTE)) {
            dependencyPath = dependencyPath.substring(1);
        }
        if (dependencyPath.endsWith(DOUBLE_QUOTES) || dependencyPath.endsWith(SINGLE_QUOTE)) {
            dependencyPath = dependencyPath.substring(0, dependencyPath.length() - 1);
        }
        if (dependencyPath.startsWith(FULL_STOP) && !dependencyPath.startsWith(DOUBLE_FULL_STOP)) {
            dependencyPath = dependencyPath.substring(1);
        }
        StringBuilder sb = new StringBuilder(pathPrefix);
        if (!dependencyPath.startsWith(FORWARD_SLASH)) {
            sb.append(FORWARD_SLASH);
        }
        sb.append(dependencyPath);
        return sb.toString();
    }

    public boolean isAllowedResourcePath(String pathToCheck) {
        if (!((String)pathToCheck).startsWith(FORWARD_SLASH)) {
            pathToCheck = FORWARD_SLASH + (String)pathToCheck;
        }
        for (Pattern pattern : this.webframeworkConfigElement.getResourcesDeniedPaths()) {
            Matcher matcher = pattern.matcher((CharSequence)pathToCheck);
            if (!matcher.matches()) continue;
            return false;
        }
        return true;
    }
}

