/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkView;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;

public class RegionView
extends AbstractWebFrameworkView {
    public RegionView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        super(webFrameworkConfiguration, modelObjectService, resourceService, renderService, templatesContainer);
    }

    public RegionView(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    @Override
    protected void renderView(RequestContext context) throws Exception {
        Map<String, String> uriTokens = this.getUriTokens();
        String scopeId = uriTokens.get("scopeId");
        String regionId = uriTokens.get("regionId");
        String sourceId = uriTokens.get("sourceId");
        if (scopeId == null) {
            scopeId = "global";
        }
        if (sourceId == null) {
            sourceId = "global";
        }
        if (regionId == null) {
            throw new RequestDispatchException("Region ID is missing");
        }
        context.getModel().put("regionId", regionId);
        context.getModel().put("regionScopeId", scopeId);
        context.getModel().put("regionSourceId", sourceId);
        if ("page".equals(scopeId)) {
            Page page = this.getObjectService().getPage(sourceId);
            if (page != null) {
                context.setPage(page);
                context.setTemplate(page.getTemplate(context));
            }
            context.getModel().put("pageId", sourceId);
        }
        if ("template".equals(scopeId)) {
            TemplateInstance templateInstance = this.getObjectService().getTemplate(sourceId);
            if (templateInstance != null) {
                context.setTemplate(templateInstance);
            }
            context.getModel().put("templateId", sourceId);
        }
        this.getRenderService().renderRegion(context, RenderFocus.BODY, sourceId, regionId, scopeId, null, false);
    }
}

