/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.BasicExtensionModule;
import org.springframework.extensions.surf.extensibility.Customization;
import org.springframework.extensions.surf.extensibility.ExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.ExtensionModuleEvaluator;
import org.springframework.extensions.surf.extensibility.WebScriptExtensibilityModuleHandler;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;

public class BasicExtensibilityModuleHandler
extends WebScriptExtensibilityModuleHandler
implements ExtensibilityModuleHandler,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(BasicExtensibilityModuleHandler.class);
    private ModuleDeploymentService moduleDeploymentService;
    private ModelObjectService modelObjectService;
    private ExtensionModuleEvaluator defaultModuleEvaluator = null;
    private ApplicationContext applicationContext = null;

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    public ModelObjectService getModelObjectService() {
        return this.modelObjectService;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setDefaultModuleEvaluator(ExtensionModuleEvaluator defaultModuleEvaluator) {
        this.defaultModuleEvaluator = defaultModuleEvaluator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public List<String> getExtendingModuleFiles(ExtensionModule module, String path) {
        List customizationPaths = super.getExtendingModuleFiles((BasicExtensionModule)module, path);
        return customizationPaths;
    }

    @Override
    public LinkedHashSet<String> getModuleJsDeps(ExtensionModule module, String path) {
        LinkedHashSet<String> jsDeps = new LinkedHashSet<String>();
        for (Customization customization : module.getCustomizations()) {
            String targetPackage;
            if (customization.getTargetPackageName() == null || !path.startsWith(targetPackage = customization.getTargetPackageName().replace(".", "/"))) continue;
            jsDeps.addAll(customization.getJsDependencies());
        }
        return jsDeps;
    }

    @Override
    public Map<String, LinkedHashSet<String>> getModuleCssDeps(ExtensionModule module, String path) {
        HashMap<String, LinkedHashSet<String>> cssDeps = new HashMap<String, LinkedHashSet<String>>();
        for (Customization customization : module.getCustomizations()) {
            String targetPackage;
            if (customization.getTargetPackageName() == null || !path.startsWith(targetPackage = customization.getTargetPackageName().replace(".", "/"))) continue;
            for (Map.Entry entry : customization.getCssDependencies().entrySet()) {
                LinkedHashSet mediaSpecificDependencies = (LinkedHashSet)cssDeps.get(entry.getKey());
                if (mediaSpecificDependencies == null) {
                    mediaSpecificDependencies = new LinkedHashSet();
                    cssDeps.put((String)entry.getKey(), mediaSpecificDependencies);
                }
                mediaSpecificDependencies.addAll((Collection)entry.getValue());
            }
        }
        return cssDeps;
    }

    @Override
    public List<ExtensionModule> evaluateModules(RequestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluating modules for request: " + context.getUri()));
        }
        ArrayList<ExtensionModule> modules = new ArrayList<ExtensionModule>();
        if (this.moduleDeploymentService != null) {
            for (ModuleDeployment module : this.moduleDeploymentService.getDeployedModules()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Evaluating module: " + module.getId()));
                }
                if (!this.applyModule(module, context)) continue;
                modules.add(module.getExtensionModule());
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"No module deployment service has been configured in the application context, applicable modules cannot be discovered");
        }
        return modules;
    }

    protected boolean applyModule(ModuleDeployment module, RequestContext context) {
        boolean apply = false;
        ExtensionModuleEvaluator moduleEvaluator = null;
        if (module.getEvaluator() != null) {
            try {
                moduleEvaluator = (ExtensionModuleEvaluator)this.applicationContext.getBean(module.getEvaluator(), ExtensionModuleEvaluator.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("The following exception occurred retrieving evaluator: " + module.getEvaluator()), (Throwable)e);
                }
            }
        } else if (this.defaultModuleEvaluator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using default module evaluator on module '" + module.getId() + "'"));
            }
            moduleEvaluator = this.defaultModuleEvaluator;
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("No evaluator defined for module: '" + (module != null ? module.getId() : null) + "' and no default configured - module will not be applied"));
        }
        if (moduleEvaluator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluating module : '" + (module != null ? module.getId() : null) + "' using evaluator '" + String.valueOf(moduleEvaluator.getClass()) + "'"));
            }
            apply = moduleEvaluator.applyModule(context, module.getEvaluatorProperties());
        }
        return apply;
    }
}

