/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.cache.CacheItem;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.webscripts.Store;

public class ModelObjectCache
implements ContentCache<ModelObject>,
CacheReporter {
    private static final int MAX_SIZE = -1;
    protected final Store store;
    protected final long delay;
    protected final int maxSize;
    protected final Map<String, CacheItem<ModelObject>> cache;

    public ModelObjectCache(Store store, long delay) {
        this(store, -1, delay);
    }

    public ModelObjectCache(Store store, int maxSize, long delay) {
        this.delay = delay;
        this.store = store;
        this.maxSize = maxSize;
        this.cache = maxSize != -1 ? new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(maxSize).weigher(Weighers.singleton()).listener((EvictionListener)new EvictionListener<String, CacheItem<ModelObject>>(){

            public void onEviction(String key, CacheItem<ModelObject> value) {
                if (value.object instanceof Component) {
                    Component c = (Component)value.object;
                    c.onEviction();
                }
            }
        }).build() : new ConcurrentHashMap<String, CacheItem<ModelObject>>(1024, 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject get(String key) {
        ModelObject obj = null;
        CacheItem<ModelObject> item = this.cache.get(key);
        if (item != null) {
            obj = (ModelObject)item.object;
            if (this.delay >= 0L) {
                CacheItem<ModelObject> cacheItem = item;
                synchronized (cacheItem) {
                    long now = System.currentTimeMillis();
                    if (this.delay < now - item.lastChecked) {
                        item.lastChecked = now;
                        if (obj != ModelObjectSentinel.instance) {
                            String path = obj.getStoragePath();
                            try {
                                if (this.store.lastModified(path) > obj.getModificationTime()) {
                                    this.remove(key);
                                    obj = null;
                                }
                            }
                            catch (IOException ex) {
                                this.remove(key);
                                obj = null;
                            }
                        } else {
                            this.remove(key);
                            obj = null;
                        }
                    }
                }
            }
        }
        return obj;
    }

    @Override
    public void invalidate() {
        this.cache.clear();
    }

    @Override
    public void put(String key, ModelObject obj) {
        this.put(key, obj, -1L);
    }

    @Override
    public void put(String key, ModelObject obj, long timeout) {
        CacheItem<ModelObject> item = new CacheItem<ModelObject>(key, obj, timeout);
        this.cache.put(key, item);
    }

    @Override
    public void remove(String key) {
        if (key == null) {
            return;
        }
        this.cache.remove(key);
    }

    public Collection<CacheItem<ModelObject>> values() {
        return this.cache.values();
    }

    public Set<String> keys() {
        return this.cache.keySet();
    }

    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(1);
        long size = 0L;
        for (String key : this.cache.keySet()) {
            CacheItem<ModelObject> v = this.cache.get(key);
            if (v == null) continue;
            size += (long)(key.length() * 2 + 128);
            String xml = ((ModelObject)v.object).toXML();
            if (xml == null) continue;
            size += (long)(xml.length() * 2 + 64);
            size += (long)(((ModelObject)v.object).getModelProperties().size() * 128 + 32);
            size += (long)(((ModelObject)v.object).getCustomProperties().size() * 128 + 32);
            size += 1024L;
        }
        reports.add(new CacheReport("modelObjectCache:" + this.store.toString(), this.cache.size(), size));
        return reports;
    }

    @Override
    public void clearCaches() {
        this.invalidate();
    }

    public static class ModelObjectSentinel
    extends AbstractModelObject {
        private static ModelObjectSentinel instance = new ModelObjectSentinel();

        private ModelObjectSentinel() {
        }

        public static ModelObjectSentinel getInstance() {
            return instance;
        }

        @Override
        public String getTypeId() {
            return "ModelObjectSentinel";
        }
    }
}

