/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ObjectPersistenceService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceProvider;
import org.springframework.extensions.surf.types.Chrome;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.ComponentType;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.ContentAssociation;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.PageAssociation;
import org.springframework.extensions.surf.types.PageType;
import org.springframework.extensions.surf.types.SurfBug;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.TemplateType;
import org.springframework.extensions.surf.types.Theme;

public class ModelObjectService {
    private ObjectPersistenceService objectPersistenceService = null;

    public void setObjectPersistenceService(ObjectPersistenceService service) {
        this.objectPersistenceService = service;
    }

    public ObjectPersistenceService getObjectPersistenceService() {
        return this.objectPersistenceService;
    }

    public Chrome getChrome(String objectId) {
        Chrome chrome = (Chrome)this.getObject("chrome", objectId);
        return chrome;
    }

    public SurfBug getSurfBug(String objectId) {
        SurfBug surfbug = (SurfBug)this.getObject("surfbug", objectId);
        return surfbug;
    }

    public Component getComponent(String objectId) {
        Component component = (Component)this.getObject("component", objectId);
        return component;
    }

    public Component getComponent(String scope, String regionId, String sourceId) {
        String componentId = RenderUtil.generateComponentId(scope, regionId, sourceId);
        Component component = this.getComponent(componentId);
        return component;
    }

    public ComponentType getComponentType(String objectId) {
        return (ComponentType)this.getObject("component-type", objectId);
    }

    public Configuration getConfiguration(String objectId) {
        return (Configuration)this.getObject("configuration", objectId);
    }

    public ContentAssociation getContentAssociation(String objectId) {
        return (ContentAssociation)this.getObject("content-association", objectId);
    }

    public Page getPage(String objectId) {
        return (Page)this.getObject("page", objectId);
    }

    public PageType getPageType(String objectId) {
        return (PageType)this.getObject("page-type", objectId);
    }

    public PageAssociation getPageAssociation(String objectId) {
        return (PageAssociation)this.getObject("page-association", objectId);
    }

    public TemplateInstance getTemplate(String objectId) {
        return (TemplateInstance)this.getObject("template-instance", objectId);
    }

    public TemplateType getTemplateType(String objectId) {
        return (TemplateType)this.getObject("template-type", objectId);
    }

    public Theme getTheme(String objectId) {
        return (Theme)this.getObject("theme", objectId);
    }

    public Chrome newChrome() {
        return (Chrome)this.newObject("chrome");
    }

    public Chrome newChrome(String objectId) {
        return (Chrome)this.newObject("chrome", objectId);
    }

    public Component newComponent() {
        return (Component)this.newObject("component");
    }

    public Component newComponent(String objectId) {
        return (Component)this.newObject("component", objectId);
    }

    public Component newComponent(String scope, String regionId, String sourceId) {
        String componentId = RenderUtil.generateComponentId(scope, regionId, sourceId);
        Component component = this.newComponent(componentId);
        component.setScope(scope);
        component.setRegionId(regionId);
        component.setSourceId(sourceId);
        return component;
    }

    public ComponentType newComponentType() {
        return (ComponentType)this.newObject("component-type");
    }

    public ComponentType newComponentType(String objectId) {
        return (ComponentType)this.newObject("component-type", objectId);
    }

    public Configuration newConfiguration() {
        return (Configuration)this.newObject("configuration");
    }

    public Configuration newConfiguration(String objectId) {
        return (Configuration)this.newObject("configuration", objectId);
    }

    public ContentAssociation newContentAssociation() {
        return (ContentAssociation)this.newObject("content-association");
    }

    public ContentAssociation newContentAssociation(String objectId) {
        return (ContentAssociation)this.newObject("content-association", objectId);
    }

    public Page newPage() {
        return (Page)this.newObject("page");
    }

    public Page newPage(String objectId) {
        return (Page)this.newObject("page", objectId);
    }

    public PageType newPageType() {
        return (PageType)this.newObject("page-type");
    }

    public PageType newPageType(String objectId) {
        return (PageType)this.newObject("page-type", objectId);
    }

    public PageAssociation newPageAssociation() {
        return (PageAssociation)this.newObject("page-association");
    }

    public PageAssociation newPageAssociation(String objectId) {
        return (PageAssociation)this.newObject("page-association", objectId);
    }

    public TemplateInstance newTemplate() {
        return (TemplateInstance)this.newObject("template-instance");
    }

    public TemplateInstance newTemplate(String objectId) {
        return (TemplateInstance)this.newObject("template-instance", objectId);
    }

    public TemplateType newTemplateType() {
        return (TemplateType)this.newObject("template-type");
    }

    public TemplateType newTemplateType(String objectId) {
        return (TemplateType)this.newObject("template-type", objectId);
    }

    public Theme newTheme() {
        return (Theme)this.newObject("theme");
    }

    public Theme newTheme(String objectId) {
        return (Theme)this.newObject("theme", objectId);
    }

    public boolean saveObject(ModelObject object) throws ModelObjectPersisterException {
        return this.getObjectPersistenceService().saveObject(object);
    }

    public boolean saveObjects(List<ModelObject> objects) throws ModelObjectPersisterException {
        return this.getObjectPersistenceService().saveObjects(objects);
    }

    public ModelObject getObject(String objectTypeId, String objectId) {
        if (objectTypeId == null) {
            throw new IllegalArgumentException("ObjectTypeId is mandatory.");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("ObjectId is mandatory.");
        }
        ObjectPersistenceService ops = this.getObjectPersistenceService();
        ModelObject object = ops.getObject(objectTypeId, objectId);
        return object;
    }

    public boolean removeObject(ModelObject object) {
        return this.getObjectPersistenceService().removeObject(object);
    }

    public boolean removeObject(String objectTypeId, String objectId) {
        return this.getObjectPersistenceService().removeObject(objectTypeId, objectId);
    }

    public ModelObject newObject(String objectTypeId) {
        return this.getObjectPersistenceService().newObject(objectTypeId);
    }

    public ModelObject newObject(String objectTypeId, String objectId) {
        return this.getObjectPersistenceService().newObject(objectTypeId, objectId);
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId) {
        return this.getObjectPersistenceService().getAllObjects(objectTypeId);
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId, String objectIdPattern) {
        return this.getObjectPersistenceService().getAllObjects("component", objectIdPattern);
    }

    public Map<String, ModelObject> findChrome() {
        return this.findChrome(null);
    }

    public Map<String, ModelObject> findChrome(String chromeType) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "chrome-type", chromeType);
        return this.findObjects("chrome", propertyConstraintMap);
    }

    public Map<String, ModelObject> findConfigurations() {
        return this.findConfigurations(null);
    }

    public Map<String, ModelObject> findConfigurations(String sourceId) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        if (sourceId != null) {
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "source-id", sourceId);
        }
        return this.findObjects("configuration", propertyConstraintMap);
    }

    public Map<String, ModelObject> findPageAssociations() {
        return this.findPageAssociations(null, null, null);
    }

    public Map<String, ModelObject> findPageAssociations(String sourceId, String destId, String associationType) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        if (sourceId != null) {
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "source-id", sourceId);
        }
        if (destId != null) {
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "dest-id", destId);
        }
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "assoc-type", associationType);
        Map<String, ModelObject> map = this.findObjects("page-association", propertyConstraintMap);
        Vector<Map.Entry<String, ModelObject>> list = new Vector<Map.Entry<String, ModelObject>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, ModelObject>>(){

            @Override
            public int compare(Map.Entry<String, ModelObject> entry, Map.Entry<String, ModelObject> entry1) {
                String sortOrder = entry.getValue().getProperty("order-id");
                String sortOrder1 = entry1.getValue().getProperty("order-id");
                if (sortOrder == null && sortOrder1 == null) {
                    return 0;
                }
                if (sortOrder == null) {
                    return -1;
                }
                if (sortOrder1 == null) {
                    return 1;
                }
                return sortOrder.compareTo(sortOrder1);
            }
        });
        map = new LinkedHashMap<String, ModelObject>(list.size());
        for (Map.Entry entry : list) {
            map.put((String)entry.getKey(), (ModelObject)entry.getValue());
        }
        return map;
    }

    public Map<String, ModelObject> findContentAssociations() {
        return this.findContentAssociations(null, null, null, null, null);
    }

    public Map<String, ModelObject> findContentAssociations(String sourceId, String sourceType, String destId, String assocType, String formatId) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "source-id", sourceId);
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "source-type", sourceType);
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "dest-id", destId);
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "assoc-type", assocType);
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "format-id", formatId);
        return this.findObjects("content-association", propertyConstraintMap);
    }

    public Map<String, ModelObject> findComponents() {
        return this.findObjects("component");
    }

    public Map<String, ModelObject> findComponents(String componentTypeId) {
        return this.findComponents(null, null, null, componentTypeId);
    }

    public Map<String, ModelObject> findComponents(String scope, String regionId, String sourceId, String componentTypeId) {
        if (componentTypeId != null || scope == null && regionId == null && sourceId == null) {
            Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "scope", scope);
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "region-id", regionId);
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "source-id", sourceId);
            ModelObjectService.addPropertyConstraint(propertyConstraintMap, "component-type-id", componentTypeId);
            return this.findObjects("component", propertyConstraintMap);
        }
        if (scope == null) {
            scope = "*";
        }
        if (regionId == null) {
            regionId = "*";
        }
        if (sourceId == null) {
            sourceId = "*";
        }
        String filter = RenderUtil.generateComponentId(scope, regionId, sourceId);
        return this.getAllObjects("component", filter);
    }

    public Map<String, ModelObject> findTemplates() {
        return this.findTemplates(null);
    }

    public Map<String, ModelObject> findTemplates(String templateType) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "template-type", templateType);
        return this.findObjects("template-instance", propertyConstraintMap);
    }

    public Map<String, ModelObject> findTemplateTypes() {
        return this.findTemplateTypes(null);
    }

    public Map<String, ModelObject> findTemplateTypes(String uri) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "uri", uri);
        return this.findObjects("template-type", propertyConstraintMap);
    }

    public Map<String, ModelObject> findComponentTypes() {
        return this.findComponentTypes(null);
    }

    public Map<String, ModelObject> findComponentTypes(String uri) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "uri", uri);
        return this.findObjects("component-type", propertyConstraintMap);
    }

    public Map<String, ModelObject> findPages() {
        return this.findPages(null, null);
    }

    public Map<String, ModelObject> findPages(String templateId, String pageTypeId) {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "template-instance", templateId);
        ModelObjectService.addPropertyConstraint(propertyConstraintMap, "page-type-id", pageTypeId);
        return this.findObjects("page", propertyConstraintMap);
    }

    public Map<String, ModelObject> findPageTypes() {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        return this.findObjects("page-type", propertyConstraintMap);
    }

    public Map<String, ModelObject> findThemes() {
        Map<String, Object> propertyConstraintMap = this.newPropertyConstraintMap();
        return this.findObjects("theme", propertyConstraintMap);
    }

    public Map<String, ModelObject> findObjects(String objectTypeId) {
        return this.findObjects(objectTypeId, null);
    }

    public void associatePage(String sourceId, String destId) throws ModelObjectPersisterException {
        this.associatePage(sourceId, destId, "child");
    }

    public void associatePage(String sourceId, String destId, String associationType) throws ModelObjectPersisterException {
        this.unassociatePage(sourceId, destId, associationType);
        PageAssociation pageAssociation = this.newPageAssociation();
        pageAssociation.setSourceId(sourceId);
        pageAssociation.setDestId(destId);
        pageAssociation.setAssociationType(associationType);
        this.saveObject(pageAssociation);
    }

    public void unassociatePage(String sourceId, String destId) {
        this.unassociatePage(sourceId, destId, "child");
    }

    public void unassociatePage(String sourceId, String destId, String associationTypeId) {
        Map<String, ModelObject> objects = this.findPageAssociations(sourceId, destId, associationTypeId);
        for (String pageAssociationId : objects.keySet()) {
            this.unassociatePage(pageAssociationId);
        }
    }

    public void unassociatePage(String pageAssociationId) {
        this.removeObject("page-association", pageAssociationId);
    }

    public void associateContent(String sourceId, String sourceType, String destId, String assocType, String formatId) throws ModelObjectPersisterException {
        this.unassociateContent(sourceId, sourceType, destId, assocType, formatId);
        ContentAssociation association = this.newContentAssociation();
        association.setSourceId(sourceId);
        association.setSourceType(sourceType);
        association.setDestId(destId);
        association.setAssociationType(assocType);
        association.setFormatId(formatId);
        this.saveObject(association);
    }

    public void unassociateContent(String sourceId, String sourceType, String destId, String assocType, String formatId) {
        Map<String, ModelObject> objects = this.findContentAssociations(sourceId, sourceType, destId, assocType, formatId);
        for (String associationId : objects.keySet()) {
            this.unassociateContent(associationId);
        }
    }

    public void unassociateContent(String objectAssociationId) {
        this.removeObject("content-association", objectAssociationId);
    }

    public void associateTemplate(String templateId, String pageId) throws ModelObjectPersisterException {
        this.associateTemplate(templateId, pageId, null);
    }

    public void associateTemplate(String templateId, String pageId, String formatId) throws ModelObjectPersisterException {
        Page page = this.getPage(pageId);
        page.setTemplateId(templateId, formatId);
        this.saveObject(page);
    }

    public void unassociateTemplate(String pageId) throws ModelObjectPersisterException {
        this.unassociateTemplate(pageId, null);
    }

    public void unassociateTemplate(String pageId, String formatId) throws ModelObjectPersisterException {
        Page page = this.getPage(pageId);
        page.removeTemplateId(formatId);
        this.saveObject(page);
    }

    public void bindComponent(String componentId, String scope, String regionId, String sourceId) throws ModelObjectPersisterException {
        Component component = this.getComponent(componentId);
        this.bindComponent(component, scope, regionId, sourceId);
    }

    public void bindComponent(Component component, String scope, String regionId, String sourceId) throws ModelObjectPersisterException {
        Component existingComponent = this.getComponent(scope, regionId, sourceId);
        if (existingComponent != null) {
            this.removeObject(existingComponent);
        }
        component.setScope(scope);
        component.setSourceId(sourceId);
        component.setRegionId(regionId);
        this.saveObject(component);
    }

    public void unbindComponent(String componentId) {
        Component existingComponent = this.getComponent(componentId);
        if (existingComponent != null) {
            this.removeObject(existingComponent);
        }
    }

    public void unbindComponent(String scope, String regionId, String sourceId) {
        Component existingComponent = this.getComponent(scope, regionId, sourceId);
        if (existingComponent != null) {
            this.removeObject(existingComponent);
        }
    }

    protected Map<String, Object> newPropertyConstraintMap() {
        return new HashMap<String, Object>(8, 1.0f);
    }

    protected static void addPropertyConstraint(Map<String, Object> propertyConstraintMap, String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            propertyConstraintMap.put(propertyName, propertyValue);
        }
    }

    protected Map<String, ModelObject> findObjects(String objectTypeId, Map<String, Object> propertyConstraintMap) {
        Map<String, ModelObject> objectsMap = this.getAllObjects(objectTypeId);
        ArrayList<String> toRemove = new ArrayList<String>(objectsMap.size());
        for (String objectKey : objectsMap.keySet()) {
            boolean found = true;
            ModelObject object = objectsMap.get(objectKey);
            if (propertyConstraintMap != null) {
                for (String propertyName : propertyConstraintMap.keySet()) {
                    boolean currentValue;
                    Object propertyValue = propertyConstraintMap.get(propertyName);
                    if (propertyValue == null) continue;
                    if (propertyValue instanceof String) {
                        String currentValue2 = object.getProperty(propertyName);
                        if (propertyValue.equals(currentValue2)) continue;
                        found = false;
                        break;
                    }
                    if (!(propertyValue instanceof Boolean) || (currentValue = object.getBooleanProperty(propertyName)) == (Boolean)propertyValue) continue;
                    found = false;
                    break;
                }
            }
            if (found) continue;
            toRemove.add(objectKey);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            objectsMap.remove(toRemove.get(i));
        }
        return objectsMap;
    }

    public boolean hasPage(String objectId) {
        return this.hasObject("page", objectId);
    }

    public boolean hasObject(String objectTypeId, String objectId) {
        if (objectTypeId == null) {
            throw new IllegalArgumentException("ObjectTypeId is mandatory");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("ObjectId is mandatory");
        }
        ObjectPersistenceService ops = this.getObjectPersistenceService();
        return ops.hasObject(objectTypeId, objectId);
    }

    public ModelObject clone(String objectTypeId, String objectId) {
        return this.clone(objectTypeId, objectId, null);
    }

    public ModelObject clone(String objectTypeId, String objectId, String newObjectId) {
        ModelObject newObject = this.newObject(objectTypeId);
        ModelObject object = this.getObject(objectTypeId, objectId);
        Map<String, Serializable> properties = object.getProperties();
        for (String propertyName : properties.keySet()) {
            Serializable propertyValue = properties.get(propertyName);
            newObject.setProperty(propertyName, (String)((Object)propertyValue));
        }
        if (object instanceof ResourceProvider) {
            ResourceProvider source = (ResourceProvider)((Object)object);
            ResourceProvider dest = (ResourceProvider)((Object)newObject);
            Resource[] resources = source.getResources();
            for (int i = 0; i < resources.length; ++i) {
                String name = resources[i].getName();
                String _protocolId = resources[i].getProtocolId();
                String _endpointId = resources[i].getEndpointId();
                String _objectId = resources[i].getObjectId();
                dest.addResource(name, _protocolId, _endpointId, _objectId);
            }
        }
        return newObject;
    }
}

