/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.CssThemeHandler;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.webscripts.ScriptConfigModel;

public abstract class LessCssThemeHandler
extends CssThemeHandler {
    private static final Log logger = LogFactory.getLog(LessCssThemeHandler.class);
    public static final String LESS_TOKEN = "less-variables";
    private String defaultLessConfig = null;

    protected String getDefaultLessConfig() {
        block8: {
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            if (this.defaultLessConfig == null) {
                String defaultLessConfigPath = null;
                ScriptConfigModel config = rc.getExtendedScriptConfigModel(null);
                Map configs = (Map)config.getScoped().get("WebFramework");
                if (configs != null) {
                    WebFrameworkConfigElement wfce = (WebFrameworkConfigElement)configs.get("web-framework");
                    defaultLessConfigPath = wfce.getDojoDefaultLessConfig();
                } else {
                    defaultLessConfigPath = this.getWebFrameworkConfigElement().getDojoDefaultLessConfig();
                }
                try {
                    InputStream in = this.getDependencyHandler().getResourceInputStream(defaultLessConfigPath);
                    if (in != null) {
                        this.defaultLessConfig = this.getDependencyHandler().convertResourceToString(in);
                    } else {
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)("Could not find the default LESS configuration at: " + defaultLessConfigPath));
                        }
                        this.defaultLessConfig = "";
                    }
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block8;
                    logger.error((Object)("An exception occurred retrieving the default LESS configuration from: " + defaultLessConfigPath), (Throwable)e);
                }
            }
        }
        return this.defaultLessConfig;
    }

    public String getLessVariables() {
        String themeVariables;
        Object variables = this.getDefaultLessConfig();
        Theme currentTheme = ThreadLocalRequestContext.getRequestContext().getTheme();
        if (currentTheme == null) {
            currentTheme = ThreadLocalRequestContext.getRequestContext().getObjectService().getTheme("default");
        }
        if ((themeVariables = currentTheme.getCssTokens().get(LESS_TOKEN)) != null) {
            variables = (String)variables + "\n" + themeVariables;
        }
        return variables;
    }

    public String logLessException(Exception e, String path) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String errorMsg = "LESS for Java Engine error compiling: '" + path + "': " + sw.toString();
        if (logger.isErrorEnabled()) {
            logger.error((Object)errorMsg);
        }
        return errorMsg;
    }
}

