/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.directives.OutputJavaScriptContentModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyResource;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyRule;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.webscripts.ScriptConfigModel;

public class DojoDependencyHandler
implements CacheReporter {
    private static final Log logger = LogFactory.getLog(DojoDependencyHandler.class);
    public static final String WIDGET_NAME = "name";
    public static final String WIDGET_CONFIG = "config";
    public static final String WIDGETS_LIST = "widgets";
    public static final String REQUEST_PACKAGES = "__dojoRequestPackages";
    private DependencyHandler dependencyHandler = null;
    private DependencyAggregator dependencyAggregator = null;
    private WebFrameworkConfigElement webFrameworkConfigElement = null;
    private List<DojoDependencyRule> dependencyRules;
    private final ReadWriteLock cachedDepsLock = new ReentrantReadWriteLock();
    private final Map<String, DojoDependencies> cachedDeps = new HashMap<String, DojoDependencies>(1024);
    private final ReadWriteLock cachedResourceLock = new ReentrantReadWriteLock();
    private Map<String, DependencyResource> generatedResourceCache = null;
    private final ReadWriteLock dependenciesChecksumLock = new ReentrantReadWriteLock();
    private Map<String, String> dependenciesChecksumCache = null;

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setDependencyRules(List<DojoDependencyRule> dependencyRules) {
        this.dependencyRules = dependencyRules;
    }

    private DojoDependencies getCachedDeps(String path) {
        DojoDependencies deps = null;
        this.cachedDepsLock.readLock().lock();
        try {
            deps = this.cachedDeps.get(path);
        }
        finally {
            this.cachedDepsLock.readLock().unlock();
        }
        return deps;
    }

    private void cacheDeps(String path, DojoDependencies deps) {
        this.cachedDepsLock.writeLock().lock();
        try {
            this.cachedDeps.put(path, deps);
        }
        finally {
            this.cachedDepsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearCaches() {
        this.dependenciesChecksumLock.writeLock().lock();
        try {
            this.dependenciesChecksumCache = null;
        }
        finally {
            this.dependenciesChecksumLock.writeLock().unlock();
        }
        this.cachedDepsLock.writeLock().lock();
        try {
            this.cachedDeps.clear();
        }
        finally {
            this.cachedDepsLock.writeLock().unlock();
        }
        this.cachedResourceLock.writeLock().lock();
        try {
            this.generatedResourceCache = null;
        }
        finally {
            this.cachedResourceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(3);
        long size = 0L;
        if (this.dependenciesChecksumCache != null) {
            size = this.dependenciesChecksumCache.size() * 512;
            reports.add(new CacheReport("dependenciesChecksumCache", this.dependenciesChecksumCache.size(), size));
        }
        size = 0L;
        this.cachedDepsLock.writeLock().lock();
        try {
            for (DojoDependencies d : this.cachedDeps.values()) {
                size += (long)(d.getCssDeps().size() * 256);
                size += (long)(d.getI18nDeps().size() * 256);
                size += (long)(d.getJavaScriptDeps().size() * 256);
                size += (long)(d.getNonAmdDependencies().size() * 256);
                size += (long)(d.getTextDeps().size() * 256);
            }
            reports.add(new CacheReport("cachedDeps", this.cachedDeps.size(), size));
        }
        finally {
            this.cachedDepsLock.writeLock().unlock();
        }
        size = 0L;
        if (this.dependenciesChecksumCache != null) {
            this.cachedResourceLock.writeLock().lock();
            try {
                for (DependencyResource v : this.generatedResourceCache.values()) {
                    size += (long)(v.getStoredSize() + 256);
                }
                reports.add(new CacheReport("generatedResourceCache", this.generatedResourceCache.size(), size));
            }
            finally {
                this.cachedResourceLock.writeLock().unlock();
            }
        }
        return reports;
    }

    public void processString(String contents, DojoDependencies dependencies, Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        if (contents != null && dependencies != null) {
            for (DojoDependencyRule rule : this.dependencyRules) {
                rule.processRegexRules(null, contents, dependencies);
            }
            this.recursivelyProcessDependencies(dependencies, dependenciesForCurrentRequest);
        }
    }

    public DojoDependencies getDependencies(String path) {
        DojoDependencies deps = this.getCachedDeps(path);
        if (deps == null || this.dependencyAggregator.isDebugMode()) {
            try {
                String compressedFile = this.dependencyAggregator.getCompressedFile(path, DependencyAggregator.CompressionType.JAVASCRIPT);
                if (compressedFile != null) {
                    deps = new DojoDependencies();
                    for (DojoDependencyRule rule : this.dependencyRules) {
                        rule.processRegexRules(path, compressedFile, deps);
                    }
                    this.cacheDeps(path, deps);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return deps;
    }

    public void recursivelyProcessDependencies(DojoDependencies deps, Map<String, DojoDependencies> allDeps) {
        if (deps != null) {
            for (String dep : deps.getJavaScriptDeps()) {
                if (allDeps.containsKey(dep)) continue;
                DojoDependencies requestedDeps = this.getCachedDeps(dep);
                if (requestedDeps == null) {
                    requestedDeps = this.getDependencies(dep);
                }
                allDeps.put(dep, requestedDeps);
                this.recursivelyProcessDependencies(requestedDeps, allDeps);
            }
        }
    }

    private Map<String, DependencyResource> getGeneratedResourceCache() {
        if (this.generatedResourceCache == null) {
            this.cachedResourceLock.writeLock().lock();
            try {
                if (this.generatedResourceCache == null) {
                    this.generatedResourceCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.dependencyAggregator.cacheSize).concurrencyLevel(16).weigher(Weighers.singleton()).build();
                }
            }
            finally {
                this.cachedResourceLock.writeLock().unlock();
            }
        }
        return this.generatedResourceCache;
    }

    public String getCachedResource(String path) {
        String resource = null;
        try {
            DependencyResource res = this.getGeneratedResourceCache().get(path);
            if (res != null) {
                resource = new String(res.getContent(), "UTF-8");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resource;
    }

    private void cacheResource(String checksum, String resource) {
        this.getGeneratedResourceCache().put(checksum, new DependencyResource(null, resource, "UTF-8"));
    }

    private Map<String, String> getDependenciesChecksumCache() {
        if (this.dependenciesChecksumCache == null) {
            this.dependenciesChecksumLock.writeLock().lock();
            try {
                if (this.dependenciesChecksumCache == null) {
                    this.dependenciesChecksumCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.dependencyAggregator.cacheSize).concurrencyLevel(16).weigher(Weighers.singleton()).build();
                }
            }
            finally {
                this.dependenciesChecksumLock.writeLock().unlock();
            }
        }
        return this.dependenciesChecksumCache;
    }

    public String getChecksumPathForDependencies(String source) {
        String surfPackage = this.getRequestDojoPackages().get("surf");
        String checksum = surfPackage + "/" + this.dependencyHandler.generateCheckSum(source) + ".js";
        this.cacheResource(checksum, source);
        return checksum;
    }

    public String getChecksumForDependencies(Map<String, DojoDependencies> dependencies, String pagePath, DojoDependencies pageDeps) {
        String key = DojoDependencyHandler.getBuildKeyForDependencies(dependencies);
        String checksum = this.getDependenciesChecksumCache().get(key);
        if (checksum == null || this.dependencyAggregator.isDebugMode()) {
            StringBuilder aggregatedOutput = this.outputAggregateResource(dependencies, null);
            try {
                aggregatedOutput.append("\n\n").append(this.outputDependency("", pagePath, pageDeps).toString());
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("IO error during dependency aggregation: " + e.getMessage(), (Throwable)e);
            }
            checksum = this.getChecksumPathForDependencies(aggregatedOutput.toString());
            this.getDependenciesChecksumCache().put(key, checksum);
        }
        return checksum;
    }

    protected static String getBuildKeyForDependencies(Map<String, DojoDependencies> dependencies) {
        int h = 0;
        for (Map.Entry<String, DojoDependencies> entry : dependencies.entrySet()) {
            h ^= entry.getKey().hashCode();
            h ^= h >>> 20 ^ h >>> 12 ^ h >>> 7 ^ h >>> 4;
        }
        return Integer.toString(h);
    }

    protected String reverseAlias(String path) {
        for (Map.Entry<String, String> alias : this.getRequestDojoPackages().entrySet()) {
            if (!((String)path).startsWith(alias.getValue())) continue;
            path = alias.getKey() + ((String)path).substring(alias.getValue().length());
            break;
        }
        return path;
    }

    public StringBuilder outputAggregateResource(Map<String, DojoDependencies> depsToOutput, String baseUrl) {
        StringBuilder sb = new StringBuilder(256000);
        sb.append("//>>built\n");
        sb.append("require({cache:{\n");
        Iterator<Map.Entry<String, DojoDependencies>> i = depsToOutput.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Map.Entry<String, DojoDependencies> currentDependency = i.next();
                String depName = currentDependency.getKey();
                String depPath = this.getPath(baseUrl, depName);
                depName = this.reverseAlias(depName);
                if (depName.endsWith(".js")) {
                    depName = depName.substring(0, depName.length() - 3);
                }
                String dep = this.outputDependency(depName, depPath, currentDependency.getValue()).toString();
                sb.append("'");
                sb.append(depName);
                sb.append("':function(){\n");
                sb.append(dep);
                sb.append("}");
                if (i.hasNext()) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Developer Warning: " + e.getMessage()), (Throwable)e);
            }
        }
        sb.append("}});");
        return sb;
    }

    public StringBuilder outputDependency(String name, String path, DojoDependencies deps) throws IOException {
        StringBuilder currentDep = new StringBuilder(4096);
        if (deps != null && !deps.getTextDeps().isEmpty()) {
            currentDep.append("require({cache:{");
            Iterator<String> j = deps.getTextDeps().iterator();
            while (j.hasNext()) {
                String textDependency = j.next();
                currentDep.append("'url:");
                String textPath = this.getPath(path, textDependency);
                if (textPath.startsWith("/")) {
                    textPath = textPath.substring(1);
                }
                String shortTextPath = this.reverseAlias(textPath);
                currentDep.append(shortTextPath);
                currentDep.append("':");
                currentDep.append("'");
                InputStream in = this.dependencyHandler.getResourceInputStream(textPath);
                if (in != null) {
                    String textContents = this.dependencyHandler.convertResourceToString(in);
                    textContents = textContents.replace('\'', '\"').replace("\"", "\\\"").replace("\n", "").replace("\r", "");
                    currentDep.append(textContents);
                }
                currentDep.append("'");
                if (j.hasNext()) {
                    currentDep.append(",");
                }
                currentDep.append("\n");
            }
            currentDep.append("}});");
        }
        if (this.dependencyHandler.isDebugMode()) {
            InputStream in = this.dependencyHandler.getResourceInputStream(path);
            currentDep.append(this.dependencyHandler.convertResourceToString(in));
        } else {
            currentDep.append(this.dependencyAggregator.getCompressedFile(path, DependencyAggregator.CompressionType.JAVASCRIPT));
        }
        return currentDep;
    }

    public Map<String, String> getRequestDojoPackages() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        Map<String, String> dojoPackages = (Map<String, String>)((Object)rc.getValue(REQUEST_PACKAGES));
        if (dojoPackages == null) {
            ScriptConfigModel config = rc.getExtendedScriptConfigModel(null);
            Map configs = (Map)config.getScoped().get("WebFramework");
            if (configs != null) {
                WebFrameworkConfigElement wfce = (WebFrameworkConfigElement)configs.get("web-framework");
                dojoPackages = wfce.getDojoPackages();
            } else {
                dojoPackages = this.webFrameworkConfigElement.getDojoPackages();
            }
            rc.setValue(REQUEST_PACKAGES, (Serializable)((Object)dojoPackages));
        }
        return dojoPackages;
    }

    public String getPath(String sourcePath, String dependencyPath) {
        int idx;
        StringBuilder sb = new StringBuilder(64);
        if (dependencyPath.startsWith("\"") || dependencyPath.startsWith("'")) {
            dependencyPath = dependencyPath.substring(1);
        }
        if (dependencyPath.endsWith("\"") || dependencyPath.endsWith("'")) {
            dependencyPath = dependencyPath.substring(0, dependencyPath.length() - 1);
        }
        boolean usesModuleAlias = false;
        if (!(dependencyPath.startsWith(".") || dependencyPath.startsWith("..") || dependencyPath.startsWith("/") || (idx = dependencyPath.indexOf("/")) == -1)) {
            String firstFolder = dependencyPath.substring(0, idx);
            String alias = this.getRequestDojoPackages().get(firstFolder);
            if (alias != null) {
                usesModuleAlias = true;
                sb.append(alias).append(dependencyPath.substring(idx));
            }
        }
        if (!usesModuleAlias) {
            sb.append(this.dependencyHandler.getRelativePath(sourcePath, dependencyPath));
        }
        return sb.toString();
    }

    public void processControllerWidgets(List widgets, Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        if (widgets != null) {
            for (Object w : widgets) {
                Object l;
                Object m;
                if (!(w instanceof Map)) continue;
                Map map = (Map)w;
                Object s = map.get(WIDGET_NAME);
                if (s instanceof String) {
                    String widgetPath = this.getPath(null, (String)s) + ".js";
                    DojoDependencies widgetDeps = this.getDependencies(widgetPath);
                    dependenciesForCurrentRequest.put(widgetPath, widgetDeps);
                    this.recursivelyProcessDependencies(widgetDeps, dependenciesForCurrentRequest);
                }
                if (!((m = map.get(WIDGET_CONFIG)) instanceof Map) || !((l = ((Map)m).get(WIDGETS_LIST)) instanceof List)) continue;
                this.processControllerWidgets((List)l, dependenciesForCurrentRequest);
            }
        }
    }

    public void processCssDependencies(Map<String, DojoDependencies> dependenciesForCurrentRequest, OutputCSSContentModelElement outputCss, String prefix, String group) {
        Set<String> depKeys = dependenciesForCurrentRequest.keySet();
        Object[] a = depKeys.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            DojoDependencies currDep = dependenciesForCurrentRequest.get(a[i]);
            if (currDep == null || outputCss == null) continue;
            for (DojoDependencies.CssDependency cssDep : currDep.getCssDeps()) {
                outputCss.addDojoCssDependency(cssDep.getPath(), cssDep.getMediaType(), group);
            }
        }
    }

    public void processNonAmdDependencies(Map<String, DojoDependencies> dependenciesForCurrentRequest, OutputJavaScriptContentModelElement outputJs, String prefix, String group) {
        Set<String> depKeys = dependenciesForCurrentRequest.keySet();
        Object[] a = depKeys.toArray();
        for (int i = 0; i < a.length; ++i) {
            DojoDependencies currDep = dependenciesForCurrentRequest.get(a[i]);
            if (currDep == null || outputJs == null) continue;
            for (String dep : currDep.getNonAmdDependencies()) {
                outputJs.addNonAmdJavaScriptFile(dep, group);
            }
        }
    }
}

