/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.JavaScriptCompressionHandler;
import org.springframework.extensions.surf.util.StringBuilderWriter;

public class ClosureJavaScriptCompressionHandler
implements JavaScriptCompressionHandler {
    private static final Log logger = LogFactory.getLog(ClosureJavaScriptCompressionHandler.class);
    private boolean whitespaceOnly = false;

    public void setWhitespaceOnly(boolean whitespaceOnly) {
        this.whitespaceOnly = whitespaceOnly;
    }

    @Override
    public void compress(Reader reader, Writer writer) throws IOException {
        Compiler compiler = new Compiler((ErrorManager)new ClosureErrorManager());
        CompilerOptions options = new CompilerOptions();
        if (this.whitespaceOnly) {
            CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
        } else {
            options.setClosurePass(true);
            options.setRenamingPolicy(VariableRenamingPolicy.LOCAL, PropertyRenamingPolicy.OFF);
        }
        options.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT5);
        options.setLineLengthThreshold(0);
        StringBuilderWriter sw = new StringBuilderWriter(512);
        IOUtils.copy((Reader)reader, (Writer)sw);
        reader.close();
        SourceFile input = SourceFile.fromCode((String)"input.js", (String)sw.toString());
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(1);
        inputs.add(input);
        compiler.compile(Collections.emptyList(), inputs, options);
        String comp = compiler.toSource();
        writer.append(comp);
        writer.close();
    }

    private static class ClosureErrorManager
    extends BasicErrorManager {
        private final MessageFormatter formatter = LightweightMessageFormatter.withoutSource();

        private ClosureErrorManager() {
        }

        public void println(CheckLevel level, JSError error) {
            switch (level) {
                case ERROR: {
                    logger.error((Object)error.format(level, this.formatter));
                    break;
                }
                case WARNING: {
                    logger.debug((Object)error.format(level, this.formatter));
                    break;
                }
            }
        }

        protected void printSummary() {
        }
    }
}

