/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.ChromeDetectionContentModelElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.DefaultExtensibilityDirectiveData;

public class ChromeDetectionDirectiveData
extends DefaultExtensibilityDirectiveData {
    private WebFrameworkConfigElement config;
    private RequestContext context;

    public ChromeDetectionDirectiveData(String id, String action, String target, String directiveName, TemplateDirectiveBody body, Environment env, WebFrameworkConfigElement config, RequestContext context) {
        super(id, action, target, directiveName, body, env);
        this.config = config;
        this.context = context;
    }

    public WebFrameworkConfigElement getConfig() {
        return this.config;
    }

    public RequestContext getContext() {
        return this.context;
    }

    public ContentModelElement createContentModelElement() {
        String htmlId = null;
        if (!(this.context == null || this.config.getDefaultRegionChrome() != null && this.config.getDefaultRegionChrome().equals("slingshot-region-chrome"))) {
            htmlId = (String)((Object)this.context.getValue("htmlid"));
        }
        return new ChromeDetectionContentModelElement(this.getId(), this.getDirectiveName(), htmlId);
    }
}

