/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.cmis;

import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.springframework.extensions.cmis.CMISConnection;
import org.springframework.extensions.cmis.CMISConnectionManagerImpl;
import org.springframework.extensions.cmis.CMISServer;

public class CMISConnectionImpl
implements CMISConnection {
    private CMISConnectionManagerImpl connectionManager;
    private String id;
    private String internalId;
    private Session session;
    private CMISServer server;
    private String username;
    private boolean isDefault;
    private boolean isShared;

    public CMISConnectionImpl(CMISConnectionManagerImpl connectionManager, String id, Session session, CMISServer server, String username, boolean isDefault, boolean isShared) {
        if (connectionManager == null) {
            throw new IllegalArgumentException("Connection Manager must be set!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must be set!");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        this.connectionManager = connectionManager;
        this.internalId = id;
        this.id = id;
        this.session = session;
        this.server = server;
        this.username = username;
        this.isDefault = isDefault;
        this.isShared = isShared;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public CMISServer getServer() {
        return this.server;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public boolean supportsQuery() {
        if (this.session == null) {
            return false;
        }
        if (this.session.getRepositoryInfo().getCapabilities() == null) {
            return true;
        }
        return this.session.getRepositoryInfo().getCapabilities().getQueryCapability() != CapabilityQuery.NONE;
    }

    @Override
    public void close() {
        this.connectionManager.removeConnection(this);
        this.session = null;
    }

    @Override
    public int compareTo(CMISConnection conn) {
        return this.id.compareTo(conn.getId());
    }
}

