/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.cmis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.springframework.extensions.cmis.CMISConnection;
import org.springframework.extensions.cmis.CMISConnectionImpl;
import org.springframework.extensions.cmis.CMISConnectionManagerImpl;
import org.springframework.extensions.cmis.CMISServer;
import org.springframework.extensions.cmis.CMISServerImpl;
import org.springframework.extensions.cmis.CMISServersConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.ScriptParameterFactory;
import org.springframework.extensions.webscripts.ScriptParameterFactoryRegistry;

public class CMISScriptParameterFactory
implements ScriptParameterFactory {
    public static final String SERVER_NAME = "name";
    public static final String SERVER_DESCRIPTION = "description";
    public static final String DEFAULT_CONNECTION_ID = "default";
    public static final String SESSION_ATTRIBUTE = " org.springframework.extensions.cmis.usersessions";
    private ConfigService configService;
    private ScriptParameterFactoryRegistry scriptParameterFactoryRegistry;
    private final SessionFactory sessionFactory = SessionFactoryImpl.newInstance();
    private int sharedConnectionsCapacity = 100;
    private LinkedHashMap<String, CMISConnection> sharedConnections;
    private Map<String, CMISServer> servers;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void setScriptParameterFactoryRegistry(ScriptParameterFactoryRegistry scriptParameterFactoryRegistry) {
        this.scriptParameterFactoryRegistry = scriptParameterFactoryRegistry;
    }

    public void setSharedConnectionsCapacity(int sharedConnectionsCapacity) {
        this.sharedConnectionsCapacity = sharedConnectionsCapacity;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void init() {
        this.sharedConnections = new LinkedHashMap<String, CMISConnection>(this.sharedConnectionsCapacity, (float)((int)Math.ceil((double)this.sharedConnectionsCapacity / 0.75) + 1), true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CMISConnection> eldest) {
                return this.size() > CMISScriptParameterFactory.this.sharedConnectionsCapacity;
            }
        };
        this.scriptParameterFactoryRegistry.registerScriptParameterFactory((ScriptParameterFactory)this);
    }

    public Map<String, Object> getParameters(Runtime runtime) {
        CMISConnectionManagerImpl connectionManager = new CMISConnectionManagerImpl(this, runtime);
        return Collections.singletonMap("cmis", connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMISConnection createDefaultConnection(CMISConnectionManagerImpl connectionManager, CMISServer server) {
        CMISConnection connection;
        this.lock.writeLock().lock();
        try {
            Map<String, CMISConnection> userConnections = this.getUserConnectionsFromSession(connectionManager.getRuntime(), true);
            if (userConnections.containsKey(DEFAULT_CONNECTION_ID)) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            if (server == null) {
                throw new IllegalStateException("Server definition must be set!");
            }
            if (!server.getParameters().containsKey("org.apache.chemistry.opencmis.user") && ThreadLocalRequestContext.getRequestContext() != null && ThreadLocalRequestContext.getRequestContext().getUserId() != null) {
                HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
                parameters.put("org.apache.chemistry.opencmis.user", ThreadLocalRequestContext.getRequestContext().getUserId());
                server = this.createServerDefinition(server.getName(), parameters);
            }
            connection = this.createConnection(connectionManager, server, DEFAULT_CONNECTION_ID, true, false);
            userConnections.put(DEFAULT_CONNECTION_ID, connection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMISConnection createUserConnection(CMISConnectionManagerImpl connectionManager, CMISServer server, String connectionId) {
        CMISConnection connection;
        if (connectionId == null || connectionId.length() == 0) {
            throw new IllegalArgumentException("Invalid connection id!");
        }
        this.lock.writeLock().lock();
        try {
            Map<String, CMISConnection> userConnections = this.getUserConnectionsFromSession(connectionManager.getRuntime(), true);
            if (userConnections.containsKey(connectionId)) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            connection = this.createConnection(connectionManager, server, connectionId, connectionId.equals(DEFAULT_CONNECTION_ID), false);
            userConnections.put(connectionId, connection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMISConnection createSharedConnection(CMISConnectionManagerImpl connectionManager, CMISServer server, String connectionId) {
        CMISConnection connection;
        if (connectionId == null || connectionId.length() == 0 || DEFAULT_CONNECTION_ID.equals(connectionId)) {
            throw new IllegalArgumentException("Invalid connection id!");
        }
        this.lock.writeLock().lock();
        try {
            if (this.sharedConnections.containsKey(connectionId)) {
                throw new IllegalStateException("Connection id is already in use!");
            }
            connection = this.createConnection(connectionManager, server, connectionId, false, true);
            this.sharedConnections.put(connection.getInternalId(), connection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return connection;
    }

    private CMISConnection createConnection(CMISConnectionManagerImpl connectionManager, CMISServer server, String connectionId, boolean isDefault, boolean isShared) {
        Session session = this.createSession(server.getParameters());
        String username = server.getParameters().get("org.apache.chemistry.opencmis.user");
        return new CMISConnectionImpl(connectionManager, connectionId, session, server, username, isDefault, isShared);
    }

    public CMISConnection getConnection(CMISConnectionManagerImpl connectionManager) {
        return this.getConnection(connectionManager, DEFAULT_CONNECTION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMISConnection getConnection(CMISConnectionManagerImpl connectionManager, String connectionId) {
        this.lock.writeLock().lock();
        try {
            CMISConnection connection = this.sharedConnections.get(connectionId);
            if (connection != null) {
                CMISConnection cMISConnection = connection;
                return cMISConnection;
            }
            Map<String, CMISConnection> userConnections = this.getUserConnectionsFromSession(connectionManager.getRuntime(), false);
            CMISConnection cMISConnection = userConnections == null ? null : userConnections.get(connectionId);
            return cMISConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CMISConnection> getUserConnections(CMISConnectionManagerImpl connectionManager) {
        this.lock.writeLock().lock();
        try {
            Map<String, CMISConnection> userConnections = this.getUserConnectionsFromSession(connectionManager.getRuntime(), false);
            if (userConnections == null) {
                List<CMISConnection> list = Collections.emptyList();
                return list;
            }
            ArrayList<CMISConnection> result = new ArrayList<CMISConnection>(userConnections.values());
            Collections.sort(result);
            List<CMISConnection> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<CMISConnection> getSharedConnections() {
        this.lock.writeLock().lock();
        try {
            ArrayList<CMISConnection> result = new ArrayList<CMISConnection>(this.sharedConnections.values());
            Collections.sort(result);
            List<CMISConnection> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(CMISConnectionManagerImpl connectionManager, CMISConnection connection) {
        if (connection == null || connection.getInternalId() == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (connection.isShared()) {
                this.sharedConnections.remove(connection.getInternalId());
            } else {
                Map<String, CMISConnection> userConnections = this.getUserConnectionsFromSession(connectionManager.getRuntime(), false);
                if (userConnections != null) {
                    userConnections.remove(connection.getInternalId());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected Session createSession(Map<String, String> parameters) {
        if (parameters.containsKey("org.apache.chemistry.opencmis.session.repository.id")) {
            return this.sessionFactory.createSession(new HashMap<String, String>(parameters));
        }
        return ((Repository)this.sessionFactory.getRepositories(new HashMap<String, String>(parameters)).get(0)).createSession();
    }

    protected void loadServerDefintions() {
        this.lock.writeLock().lock();
        try {
            if (this.servers == null) {
                CMISServersConfigElement cmisServersConfig = (CMISServersConfigElement)this.configService.getConfig((Object)"CMIS").getConfigElement("cmis-servers");
                this.servers = cmisServersConfig != null && cmisServersConfig.getServerDefinitions() != null ? cmisServersConfig.getServerDefinitions() : new HashMap<String, CMISServer>();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<CMISServer> getServerDefinitions() {
        if (this.servers == null) {
            this.loadServerDefintions();
        }
        return Collections.unmodifiableList(new ArrayList<CMISServer>(this.servers.values()));
    }

    public CMISServer getServerDefinition(String serverName) {
        if (this.servers == null) {
            this.loadServerDefintions();
        }
        return this.servers.get(serverName);
    }

    public CMISServer createServerDefinition(String serverName, Map<String, String> parameters) {
        return new CMISServerImpl(serverName, null, parameters);
    }

    public CMISServer createServerDefinition(CMISServer server, String username, String password) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        return new CMISServerImpl(server.getName(), server.getDescription(), parameters);
    }

    public CMISServer createServerDefinition(CMISServer server, String username, String password, String repositoryId) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        HashMap<String, String> parameters = new HashMap<String, String>(server.getParameters());
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        return new CMISServerImpl(server.getName(), server.getDescription(), parameters);
    }

    public static CMISServer createServerDefinition(Map<String, String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters must be set!");
        }
        String name = parameters.get(SERVER_NAME);
        parameters.remove(SERVER_NAME);
        String description = parameters.get(SERVER_DESCRIPTION);
        parameters.remove(SERVER_DESCRIPTION);
        if (name != null) {
            return new CMISServerImpl(name, description, parameters);
        }
        return null;
    }

    public List<Repository> getRepositories(CMISServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server must be set!");
        }
        return this.sessionFactory.getRepositories(new HashMap<String, String>(server.getParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CMISConnection> getUserConnectionsFromSession(Runtime runtime, boolean create) {
        this.lock.writeLock().lock();
        try {
            HashMap<String, CMISConnection> userConnections = (HashMap<String, CMISConnection>)runtime.getSession().getValue(SESSION_ATTRIBUTE);
            if (userConnections == null && create) {
                userConnections = new HashMap<String, CMISConnection>();
                runtime.getSession().setValue(SESSION_ATTRIBUTE, userConnections);
            }
            HashMap<String, CMISConnection> hashMap = userConnections;
            return hashMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

