/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.site.servlet.AIMSFilter;
import org.alfresco.web.site.servlet.SlingshotLoginController;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.alfresco.web.site.servlet.config.CustomAuthorizationRequestResolver;
import org.alfresco.web.site.servlet.config.IdentityServiceMetadataKey;
import org.alfresco.web.site.servlet.config.SecurityUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.encoder.Encode;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ServletRequestContextFactory;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenValidator;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AIMSFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(AIMSFilter.class);
    private ApplicationContext context;
    private ConnectorService connectorService;
    private SlingshotLoginController loginController;
    private boolean enabled = false;
    private String principalAttribute;
    public static final String ALFRESCO_ENDPOINT_ID = "alfresco";
    public static final String ALFRESCO_API_ENDPOINT_ID = "alfresco-api";
    public static final String SHARE_AIMS_LOGOUT = "/page/aims/logout";
    public static final String SHARE_PAGE = "/page";
    public static final String DEFAULT_AUTHORIZATION_REQUEST_BASE_URI = "/oauth2/authorization";
    public static final String SHARE_AIMS_LOGIN_PAGE = "/page/aims-login";
    public static final String SHARE_AIMS_DOLOGIN = "/page/aims-dologin";
    public static final String SHARE_PROXY_SLINGSHOT_NODE_CONTENT = "/proxy/alfresco/slingshot/node/content";
    public static final String[] BASE_ENDPOINTS_TO_REDIRECT = new String[]{"/page", "/page/aims/logout", "/proxy/alfresco/slingshot/node/content"};
    private ClientRegistrationRepository clientRegistrationRepository;
    private OAuth2AuthorizedClientService oauth2ClientService;
    private final RedirectStrategy authorizationRedirectStrategy;
    private OAuth2AuthorizationRequestResolver authorizationRequestResolver;
    private RequestCache requestCache;
    private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
    private final DefaultRefreshTokenTokenResponseClient refreshTokenResponseClient = new DefaultRefreshTokenTokenResponseClient();
    private ThrowableAnalyzer throwableAnalyzer;
    private final JwtDecoderFactory<ClientRegistration> jwtDecoderFactory = new OidcIdTokenDecoderFactory();
    private final GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;
    private final OAuth2UserService<OidcUserRequest, OidcUser> userService = new OidcUserService();
    private String clientId;
    private String audience;
    private String shareContext;
    private List<String> endpointsToRedirect = new ArrayList();

    public AIMSFilter() {
        this.authorizationRedirectStrategy = new DefaultRedirectStrategy();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Initializing the AIMS filter.");
        }
        this.context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        AIMSConfig config = (AIMSConfig)this.context.getBean("aims.config");
        this.enabled = config.isEnabled();
        if (this.enabled) {
            this.clientId = config.getResource();
            this.principalAttribute = config.getPrincipalAttribute();
            this.audience = config.getAudience();
            this.clientRegistrationRepository = (ClientRegistrationRepository)this.context.getBean(ClientRegistrationRepository.class);
            this.oauth2ClientService = (OAuth2AuthorizedClientService)this.context.getBean(OAuth2AuthorizedClientService.class);
            this.requestCache = new HttpSessionRequestCache();
            this.authorizationRequestResolver = new CustomAuthorizationRequestResolver(this.clientRegistrationRepository, "/oauth2/authorization", config);
            this.authorizationRequestRepository = new HttpSessionOAuth2AuthorizationRequestRepository();
            this.throwableAnalyzer = new SecurityUtils.DefaultThrowableAnalyzer();
            this.shareContext = config.getShareContext();
            Collections.addAll(this.endpointsToRedirect, BASE_ENDPOINTS_TO_REDIRECT);
            String[] extraEndpointsToRedirect = config.getExtraEndpointsToRedirect();
            if (extraEndpointsToRedirect != null && extraEndpointsToRedirect.length > 0) {
                Collections.addAll(this.endpointsToRedirect, extraEndpointsToRedirect);
            }
        }
        this.connectorService = (ConnectorService)this.context.getBean("connector.service");
        this.loginController = (SlingshotLoginController)this.context.getBean("loginController");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"AIMS filter initialized.");
        }
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        boolean isAuthenticated;
        HttpSession session;
        HttpServletResponse response;
        HttpServletRequest request;
        block23: {
            SecurityContext attribute;
            request = (HttpServletRequest)sreq;
            response = (HttpServletResponse)sres;
            session = request.getSession();
            isAuthenticated = false;
            if (null != session && this.enabled && null != (attribute = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")) && (isAuthenticated = attribute.getAuthentication().isAuthenticated())) {
                try {
                    OAuth2LoginAuthenticationToken oAuth2LoginAuthenticationToken = (OAuth2LoginAuthenticationToken)attribute.getAuthentication();
                    OAuth2AccessToken oAuth2AccessToken = oAuth2LoginAuthenticationToken.getAccessToken();
                    if (AIMSFilter.isAuthTokenExpired((Instant)oAuth2AccessToken.getExpiresAt())) {
                        this.refreshToken(attribute, session);
                    }
                }
                catch (Exception oauth2AuthenticationException) {
                    LOGGER.error((Object)("Resulted in Error while doing refresh token " + oauth2AuthenticationException.getMessage()));
                    session.invalidate();
                    if (request.getRequestURI().contains(this.shareContext + "/page/aims/logout")) break block23;
                    isAuthenticated = false;
                }
            }
        }
        if (!isAuthenticated && this.enabled && this.isEndpointToRedirect(request)) {
            if (this.matchesAuthorizationResponse(request)) {
                this.processAuthorizationResponse(request, response, session);
            } else {
                try {
                    if (request.getRequestURI().contains("/page/aims-login")) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    if (!request.getRequestURI().contains("/page/aims-dologin")) {
                        this.sendRedirectForPreLogin(request, response);
                        return;
                    }
                    this.requestCache.saveRequest(request, response);
                    OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestResolver.resolve(request, this.clientId);
                    if (authorizationRequest != null) {
                        this.sendRedirectForAuthorization(request, response, authorizationRequest);
                        return;
                    }
                }
                catch (Exception var11) {
                    this.unsuccessfulRedirectForAuthorization(response);
                    return;
                }
                try {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException var9) {
                    throw var9;
                }
                catch (Exception var10) {
                    Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)var10);
                    ClientAuthorizationRequiredException authzEx = (ClientAuthorizationRequiredException)this.throwableAnalyzer.getFirstThrowableOfType(ClientAuthorizationRequiredException.class, causeChain);
                    if (authzEx != null) {
                        try {
                            OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestResolver.resolve(request, authzEx.getClientRegistrationId());
                            if (authorizationRequest == null) {
                                throw authzEx;
                            }
                            this.sendRedirectForAuthorization(request, response, authorizationRequest);
                            this.requestCache.saveRequest(request, response);
                        }
                        catch (Exception var8) {
                            this.unsuccessfulRedirectForAuthorization(response);
                        }
                    }
                    if (var10 instanceof ServletException) {
                        throw (ServletException)((Object)var10);
                    }
                    if (var10 instanceof RuntimeException) {
                        throw (RuntimeException)var10;
                    }
                    throw new RuntimeException(var10);
                }
            }
        } else {
            if (request.getRequestURI().contains("/page/aims-dologin")) {
                this.sendRedirectToOriginalTarget(request, response);
                return;
            }
            chain.doFilter(sreq, sres);
        }
    }

    private boolean isEndpointToRedirect(HttpServletRequest request) {
        String uri = request.getRequestURI();
        for (String endpoint : this.endpointsToRedirect) {
            if (!uri.contains(this.shareContext + endpoint)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccess(HttpServletRequest request, HttpServletResponse response, HttpSession session, OAuth2LoginAuthenticationToken authenticationResult) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completing the AIMS authentication.");
        }
        String username = (String)authenticationResult.getPrincipal().getAttribute(this.principalAttribute);
        String accessToken = authenticationResult.getAccessToken().getTokenValue();
        AIMSFilter aIMSFilter = this;
        synchronized (aIMSFilter) {
            try {
                this.initRequestContext(request, response);
                String alfTicket = this.getAlfTicket(session, username, accessToken);
                if (alfTicket != null) {
                    session.setAttribute("_alf_USER_ID", (Object)username);
                    session.setAttribute("_alfExternalAuthAIMS", (Object)true);
                    Connector connector = this.connectorService.getConnector("alfresco", username, session);
                    connector.getConnectorSession().setParameter("alfTicket", alfTicket);
                    CredentialVault vault = FrameworkUtil.getCredentialVault((HttpSession)session, (String)username);
                    Credentials credentials = vault.newCredentials("alfresco");
                    credentials.setProperty("cleartextUsername", (Object)username);
                    vault.store(credentials);
                    this.loginController.beforeSuccess(request, response);
                    this.initUser(request);
                } else {
                    LOGGER.error((Object)"Could not get an alfTicket from Repository.");
                }
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("Failed to complete AIMS authentication process.", (Throwable)e);
            }
        }
    }

    private void initRequestContext(HttpServletRequest request, HttpServletResponse response) throws RequestContextException {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context == null) {
            ServletRequestContextFactory factory = (ServletRequestContextFactory)this.context.getBean("webframework.factory.requestcontext.servlet");
            context = factory.newInstance((WebRequest)new ServletWebRequest(request));
            request.setAttribute("requestContext", (Object)context);
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes(request, response));
        ServletUtil.setRequest((HttpServletRequest)request);
    }

    private void initUser(HttpServletRequest request) throws UserFactoryException {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context != null && context.getUser() == null) {
            String userEndpointId = (String)((Object)context.getAttribute("alfUserEndpoint"));
            UserFactory userFactory = context.getServiceRegistry().getUserFactory();
            User user = userFactory.initialiseUser(context, request, userEndpointId);
            context.setUser(user);
        }
    }

    private String getAlfTicket(HttpSession session, String username, String accessToken) throws ConnectorServiceException {
        String alfTicket;
        block6: {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Retrieving the Alfresco Ticket from Repository.");
            }
            alfTicket = null;
            Connector connector = this.connectorService.getConnector("alfresco-api", username, session);
            ConnectorContext c = new ConnectorContext(HttpMethod.GET, null, Collections.singletonMap("Authorization", "Bearer " + accessToken));
            c.setContentType("application/json");
            Response r = connector.call("/-default-/public/authentication/versions/1/tickets/-me-?noCache=" + UUID.randomUUID().toString(), c);
            if (200 != r.getStatus().getCode()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Failed to retrieve Alfresco Ticket from Repository.");
                }
            } else {
                JSONObject json = new JSONObject(r.getText());
                try {
                    alfTicket = json.getJSONObject("entry").getString("id");
                }
                catch (JSONException e) {
                    if (!LOGGER.isErrorEnabled()) break block6;
                    LOGGER.error((Object)"Failed to parse Alfresco Ticket from Repository response.");
                }
            }
        }
        return alfTicket;
    }

    private boolean matchesAuthorizationResponse(HttpServletRequest request) {
        MultiValueMap params = SecurityUtils.toMultiMap((Map)request.getParameterMap());
        if (!SecurityUtils.isAuthorizationResponse((MultiValueMap)params)) {
            return false;
        }
        OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestRepository.loadAuthorizationRequest(request);
        if (authorizationRequest == null) {
            return false;
        }
        UriComponents requestUri = UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).build();
        UriComponents redirectUri = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri()).build();
        LinkedHashSet requestUriParameters = new LinkedHashSet(requestUri.getQueryParams().entrySet());
        LinkedHashSet redirectUriParameters = new LinkedHashSet(redirectUri.getQueryParams().entrySet());
        requestUriParameters.retainAll(redirectUriParameters);
        return Objects.equals(requestUri.getScheme(), redirectUri.getScheme()) && Objects.equals(requestUri.getUserInfo(), redirectUri.getUserInfo()) && Objects.equals(requestUri.getHost(), redirectUri.getHost()) && Objects.equals(requestUri.getPort(), redirectUri.getPort()) && Objects.equals(requestUri.getPath(), redirectUri.getPath()) && Objects.equals(((Object)requestUriParameters).toString(), ((Object)redirectUriParameters).toString());
    }

    private synchronized void processAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        OAuth2LoginAuthenticationToken authenticationResult;
        OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestRepository.removeAuthorizationRequest(request, response);
        MultiValueMap params = SecurityUtils.toMultiMap((Map)request.getParameterMap());
        String redirectUri = UrlUtils.buildFullRequestUrl((HttpServletRequest)request);
        OAuth2AuthorizationResponse authorizationResponse = SecurityUtils.convert((MultiValueMap)params, (String)redirectUri);
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(this.clientId);
        OAuth2LoginAuthenticationToken authenticationRequest = new OAuth2LoginAuthenticationToken(clientRegistration, new OAuth2AuthorizationExchange(authorizationRequest, authorizationResponse));
        authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        try {
            authenticationResult = (OAuth2LoginAuthenticationToken)this.authenticate((Authentication)authenticationRequest);
        }
        catch (OAuth2AuthorizationException var16) {
            OAuth2Error error = var16.getError();
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
            if (!StringUtils.isEmpty((Object)error.getDescription())) {
                uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
            }
            if (!StringUtils.isEmpty((Object)error.getUri())) {
                uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
            }
            this.redirectStrategy.sendRedirect(request, response, uriBuilder.build().encode().toString());
            return;
        }
        SecurityContextHolder.clearContext();
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationResult);
        Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        String principalName = currentAuthentication != null ? currentAuthentication.getPrincipal().toString() : "anonymousUser";
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(authenticationResult.getClientRegistration(), principalName, authenticationResult.getAccessToken(), authenticationResult.getRefreshToken());
        this.oauth2ClientService.saveAuthorizedClient(authorizedClient, currentAuthentication);
        String redirectUrl = authorizationRequest.getRedirectUri();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        if (SecurityContextHolder.getContext() != null && !AuthenticationUtil.isAuthenticated((HttpServletRequest)request)) {
            this.onSuccess(request, response, session, authenticationResult);
        }
        if (savedRequest != null) {
            redirectUrl = savedRequest.getRedirectUrl();
            this.requestCache.removeRequest(request, response);
        }
        this.redirectStrategy.sendRedirect(request, response, Encode.forJava((String)redirectUrl));
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AccessTokenResponse accessTokenResponse;
        OAuth2LoginAuthenticationToken authorizationCodeAuthentication = (OAuth2LoginAuthenticationToken)authentication;
        if (!authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest().getScopes().contains("openid")) {
            return null;
        }
        OAuth2AuthorizationRequest authorizationRequest = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest();
        OAuth2AuthorizationResponse authorizationResponse = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationResponse();
        if (authorizationResponse.statusError()) {
            throw new OAuth2AuthenticationException(authorizationResponse.getError(), authorizationResponse.getError().toString());
        }
        if (!authorizationResponse.getState().equals(authorizationRequest.getState())) {
            OAuth2Error oauth2Error = new OAuth2Error("invalid_state_parameter");
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        try {
            accessTokenResponse = this.accessTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)new OAuth2AuthorizationCodeGrantRequest(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange()));
        }
        catch (OAuth2AuthorizationException var14) {
            OAuth2Error oauth2Error = var14.getError();
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        ClientRegistration clientRegistration = authorizationCodeAuthentication.getClientRegistration();
        Map additionalParameters = accessTokenResponse.getAdditionalParameters();
        if (!additionalParameters.containsKey("id_token")) {
            OAuth2Error invalidIdTokenError = new OAuth2Error("invalid_id_token", "Missing (required) ID Token in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), (String)null);
            throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString());
        }
        OidcIdToken idToken = this.createOidcToken(clientRegistration, accessTokenResponse);
        String requestNonce = (String)authorizationRequest.getAttribute("nonce");
        if (requestNonce != null) {
            String nonceHash;
            try {
                nonceHash = AIMSFilter.createHash((String)requestNonce);
            }
            catch (NoSuchAlgorithmException var13) {
                OAuth2Error oauth2Error = new OAuth2Error("invalid_nonce");
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            String nonceHashClaim = idToken.getNonce();
            if (nonceHashClaim == null || !nonceHashClaim.equals(nonceHash)) {
                OAuth2Error oauth2Error = new OAuth2Error("invalid_nonce");
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
        }
        DefaultOidcUser oidcUser = new DefaultOidcUser(Collections.emptyList(), idToken, clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName());
        Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oidcUser.getAuthorities());
        OAuth2LoginAuthenticationToken authenticationResult = new OAuth2LoginAuthenticationToken(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange(), (OAuth2User)oidcUser, mappedAuthorities, accessTokenResponse.getAccessToken(), accessTokenResponse.getRefreshToken());
        authenticationResult.setDetails(authorizationCodeAuthentication.getDetails());
        return authenticationResult;
    }

    private OidcIdToken createOidcToken(ClientRegistration clientRegistration, OAuth2AccessTokenResponse accessTokenResponse) throws OAuth2AuthenticationException {
        Jwt jwt;
        try {
            jwt = this.validateIdToken(clientRegistration, (String)accessTokenResponse.getAdditionalParameters().get("id_token"));
            this.validateAccessToken(clientRegistration, accessTokenResponse.getAccessToken());
        }
        catch (JwtException jwtException) {
            OAuth2Error invalidIdTokenError = new OAuth2Error("invalid_id_token", jwtException.getMessage(), (String)null);
            throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString(), (Throwable)jwtException);
        }
        OidcIdToken idToken = new OidcIdToken(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getClaims());
        return idToken;
    }

    static String createHash(String nonce) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(nonce.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    private void sendRedirectForAuthorization(HttpServletRequest request, HttpServletResponse response, OAuth2AuthorizationRequest authorizationRequest) throws IOException {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationRequest.getGrantType())) {
            this.authorizationRequestRepository.saveAuthorizationRequest(authorizationRequest, request, response);
        }
        this.authorizationRedirectStrategy.sendRedirect(request, response, authorizationRequest.getAuthorizationRequestUri());
    }

    private void unsuccessfulRedirectForAuthorization(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    private void sendRedirectForPreLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String originalQueryString = request.getQueryString();
        String redirectUrl = request.getRequestURL().toString() + (originalQueryString != null ? "?".concat(originalQueryString) : "");
        UriComponents loginUri = UriComponentsBuilder.fromUriString((String)(request.getContextPath() + "/page/aims-login")).query(originalQueryString).queryParam("redirectUrl", new Object[]{Encode.forJava((String)redirectUrl)}).build();
        response.sendRedirect(loginUri.toUriString());
    }

    private void sendRedirectToOriginalTarget(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String originalUrl = request.getParameter("redirectUrl");
        if (originalUrl == null || originalUrl.isEmpty()) {
            this.redirectStrategy.sendRedirect(request, response, "/");
            return;
        }
        String originalFragment = request.getParameter("fragment");
        UriComponents redirectUri = UriComponentsBuilder.fromUriString((String)originalUrl).fragment(originalFragment).build();
        this.redirectStrategy.sendRedirect(request, response, redirectUri.toUriString());
    }

    private synchronized void refreshToken(SecurityContext attribute, HttpSession session) {
        OAuth2LoginAuthenticationToken oAuth2LoginAuthenticationToken = (OAuth2LoginAuthenticationToken)attribute.getAuthentication();
        ClientRegistration clientRegistration = oAuth2LoginAuthenticationToken.getClientRegistration();
        OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest = new OAuth2RefreshTokenGrantRequest(clientRegistration, oAuth2LoginAuthenticationToken.getAccessToken(), oAuth2LoginAuthenticationToken.getRefreshToken());
        OAuth2AccessTokenResponse accessTokenResponse = this.refreshTokenResponseClient.getTokenResponse(refreshTokenGrantRequest);
        OidcIdToken idToken = this.createOidcToken(clientRegistration, accessTokenResponse);
        DefaultOidcUser oidcUser = new DefaultOidcUser(Collections.emptyList(), idToken, clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName());
        Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oidcUser.getAuthorities());
        OAuth2LoginAuthenticationToken authenticationResult = new OAuth2LoginAuthenticationToken(clientRegistration, oAuth2LoginAuthenticationToken.getAuthorizationExchange(), (OAuth2User)oidcUser, mappedAuthorities, accessTokenResponse.getAccessToken(), accessTokenResponse.getRefreshToken());
        authenticationResult.setDetails(oAuth2LoginAuthenticationToken.getDetails());
        OAuth2AuthorizedClient updatedAuthorizedClient = new OAuth2AuthorizedClient(clientRegistration, oAuth2LoginAuthenticationToken.getName(), accessTokenResponse.getAccessToken(), accessTokenResponse.getRefreshToken());
        this.oauth2ClientService.saveAuthorizedClient(updatedAuthorizedClient, (Authentication)authenticationResult);
        attribute.setAuthentication((Authentication)authenticationResult);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)attribute);
    }

    private OAuth2TokenValidator<Jwt> createCustomValidator(ClientRegistration.ProviderDetails providerDetails) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator(Duration.of(0L, ChronoUnit.MILLIS)));
        validators.add(new JwtIssuerValidator((String)providerDetails.getConfigurationMetadata().get(IdentityServiceMetadataKey.ACCESS_TOKEN_ISSUER.getValue())));
        if (!StringUtils.isEmpty((Object)this.audience)) {
            validators.add(new JwtAudienceValidator(this.audience));
        }
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private Jwt validateAccessToken(ClientRegistration clientRegistration, OAuth2AccessToken oAuth2AccessToken) throws JwtException {
        NimbusJwtDecoder jwtDecoder = (NimbusJwtDecoder)this.jwtDecoderFactory.createDecoder((Object)clientRegistration);
        jwtDecoder.setJwtValidator(this.createCustomValidator(clientRegistration.getProviderDetails()));
        jwtDecoder.setClaimSetConverter((Converter)new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters()));
        return jwtDecoder.decode(oAuth2AccessToken.getTokenValue());
    }

    private Jwt validateIdToken(ClientRegistration clientRegistration, String idToken) throws JwtException {
        NimbusJwtDecoder jwtDecoder = (NimbusJwtDecoder)this.jwtDecoderFactory.createDecoder((Object)clientRegistration);
        jwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new JwtTimestampValidator(), new OidcIdTokenValidator(clientRegistration)}));
        return jwtDecoder.decode(idToken);
    }

    private static boolean isAuthTokenExpired(Instant authTokenExpiration) {
        return Instant.now().compareTo(authTokenExpiration) >= 0;
    }
}

