/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.util.GUID;
import org.alfresco.web.site.ClusterTopicService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.ClusterMessageAware;
import org.springframework.extensions.surf.ClusterService;

public class ClusterTopicService
implements MessageListener<String>,
ClusterService,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ClusterTopicService.class);
    private HazelcastInstance hazelcastInstance;
    private String hazelcastTopicName;
    private ITopic<String> clusterTopic = null;
    private Map<String, ClusterMessageAware> clusterBeans = null;
    private static final String clusterNodeId = GUID.generate();
    private ApplicationContext applicationContext = null;

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void setHazelcastTopicName(String hazelcastTopicName) {
        this.hazelcastTopicName = hazelcastTopicName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        if (this.hazelcastInstance == null) {
            throw new IllegalArgumentException("The 'hazelcastInstance' property (HazelcastInstance) is mandatory.");
        }
        if (this.hazelcastTopicName == null || this.hazelcastTopicName.length() == 0) {
            throw new IllegalArgumentException("The 'hazelcastTopicName' property (String) is mandatory.");
        }
        ITopic topic = this.hazelcastInstance.getTopic(this.hazelcastTopicName);
        if (topic == null) {
            throw new IllegalArgumentException("Did not find Hazelcast topic with name: '" + this.hazelcastTopicName + "' - cannot init.");
        }
        Map beans = this.applicationContext.getBeansOfType(ClusterMessageAware.class);
        this.clusterBeans = new HashMap();
        for (String id : beans.keySet()) {
            ClusterMessageAware bean = (ClusterMessageAware)beans.get(id);
            String messageType = bean.getClusterMessageType();
            if (messageType != null) {
                if (this.clusterBeans.containsKey(messageType)) {
                    throw new IllegalStateException("ClusterMessageAware bean with id '" + id + "' attempted to register with existing Message Type: " + messageType);
                }
                this.clusterBeans.put(messageType, bean);
            }
            bean.setClusterService((ClusterService)this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registered beans for cluster messages:");
            for (String id : beans.keySet()) {
                logger.debug((Object)(id + " [" + ((ClusterMessageAware)beans.get(id)).getClusterMessageType() + "]"));
            }
        }
        this.clusterTopic = topic;
        this.clusterTopic.addMessageListener((MessageListener)this);
        logger.info((Object)("Init complete for Hazelcast cluster - listening on topic: " + this.hazelcastTopicName));
    }

    public void publishClusterMessage(String messageType, Map<String, Serializable> payload) {
        ClusterMessageImpl msg = new ClusterMessageImpl(messageType, payload);
        String serialised = msg.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing message:\r\n" + serialised));
        }
        this.clusterTopic.publish((Object)serialised);
    }

    public void onMessage(Message<String> message) {
        boolean debug = logger.isDebugEnabled();
        String msg = (String)message.getMessageObject();
        MessageProcessor proc = new MessageProcessor(msg);
        if (!proc.isSender()) {
            ClusterMessageAware bean;
            if (debug) {
                logger.debug((Object)("Received message of type:" + proc.getMessageType() + "\r\n" + msg));
            }
            if ((bean = (ClusterMessageAware)this.clusterBeans.get(proc.getMessageType())) != null) {
                bean.onClusterMessage(proc.getMessagePayload());
            } else {
                logger.warn((Object)("Received message of unknown type - no handler bean found: " + proc.getMessageType()));
            }
        }
    }
}

