/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.packaging;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.config.packaging.ModulePackage;
import org.alfresco.web.config.packaging.ModulePackageDependency;
import org.alfresco.web.config.packaging.ModulePackageHelper;
import org.alfresco.web.config.packaging.ModulePackageManager;
import org.alfresco.web.scripts.ShareManifest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ModulePackageHelperTest {
    public static final String SIMPLE_SIMPLEMODULE_PROPERTIES = "classpath:alfresco/module/simple/simplemodule.properties";
    public static final String BAD_BADMODULE_PROPERTIES = "classpath:alfresco/module/bad/badmodule.properties";
    public static final String USER_BADMODULE_PROPERTIES = "classpath:alfresco/module/bad/usermodule.properties";
    public static final String MODULE_PENT_MODULE_PROPERTIES = "classpath:alfresco/module/pent/module.properties";
    protected static final DefaultResourceLoader loader = new DefaultResourceLoader();
    protected static ShareManifest shareManifest;
    protected static File manifestFile;

    public static ModulePackageManager setup() {
        return new ModulePackageManager();
    }

    @BeforeClass
    public static void setUp() throws Exception {
        manifestFile = File.createTempFile("Manifest-Test", "MF");
        manifestFile.deleteOnExit();
        try (PrintWriter pw = new PrintWriter(manifestFile);){
            pw.println("Specification-Title: Alfresco Share");
            pw.println("Specification-Version: 5.1");
            pw.println("Implementation-Version: 5.1-SNAPSHOT");
        }
        shareManifest = new ShareManifest((Resource)new FileSystemResource(manifestFile));
        shareManifest.readManifest();
    }

    @Test
    public void testValidVersion() throws IOException {
        Assert.assertEquals((Object)"5.1", (Object)shareManifest.getSpecificationVersion());
        Assert.assertEquals((Object)"5.1-SNAPSHOT", (Object)shareManifest.getImplementationVersion());
    }

    @Test
    public void testInValidVersion() throws IOException {
        File badFile = File.createTempFile("Bad Manifest", "MF");
        badFile.deleteOnExit();
        ShareManifest badManifest = new ShareManifest((Resource)new FileSystemResource(badFile));
        badManifest.readManifest();
        try {
            ModulePackageHelper.checkValid(null, (ShareManifest)badManifest);
            Assert.fail((String)"should throw the error");
        }
        catch (AlfrescoRuntimeException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Share Specification-Version is missing"));
            Assert.assertTrue((boolean)expected.getMessage().contains("Invalid MANIFEST.MF"));
        }
    }

    @Test
    public void testCheckValid() {
        Resource resource = loader.getResource(MODULE_PENT_MODULE_PROPERTIES);
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        ModulePackageHelper.checkValid((ModulePackage)mp, (ShareManifest)shareManifest);
        resource = loader.getResource(BAD_BADMODULE_PROPERTIES);
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        ModulePackageHelper.checkValid((ModulePackage)mp, (ShareManifest)shareManifest);
    }

    @Test
    public void testCheckVersions() {
        Resource resource = loader.getResource(SIMPLE_SIMPLEMODULE_PROPERTIES);
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        try {
            ModulePackageHelper.checkValid((ModulePackage)mp, (ShareManifest)shareManifest);
            Assert.assertFalse((boolean)true);
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("cannot be installed on a Share version greater than 2.1"));
        }
        resource = loader.getResource(USER_BADMODULE_PROPERTIES);
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        try {
            ModulePackageHelper.checkValid((ModulePackage)mp, (ShareManifest)shareManifest);
            Assert.assertFalse((boolean)true);
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("must be installed on a Share version equal to or greater than 5.2"));
        }
    }

    @Test
    public void testCheckDependencies() throws Exception {
        Resource resource = loader.getResource(BAD_BADMODULE_PROPERTIES);
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        List deps = mp.getDependencies();
        List mods = new ModulePackageManager().resolveModules("classpath*:alfresco/module/*/module.properties");
        Assert.assertNotNull((Object)mods);
        Assert.assertNotNull((Object)deps);
        Assert.assertTrue((String)"Bad module has no dependencies", (boolean)deps.isEmpty());
        ModulePackageHelper.checkDependencies((ModulePackage)mp, (List)mods);
        resource = loader.getResource(MODULE_PENT_MODULE_PROPERTIES);
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        ModulePackageHelper.checkDependencies((ModulePackage)mp, (List)mods);
        try {
            resource = loader.getResource(SIMPLE_SIMPLEMODULE_PROPERTIES);
            mp = ModulePackageManager.asModulePackage((Resource)resource);
            ModulePackageHelper.checkDependencies((ModulePackage)mp, (List)mods);
            Assert.assertFalse((boolean)true);
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("cannot be installed. The following modules must first be installed:"));
            Assert.assertTrue((boolean)are.getMessage().contains("net.sf.myproject.module.SupportModuleA"));
            Assert.assertTrue((boolean)are.getMessage().contains("net.sf.myproject.module.SupportModuleB"));
            Assert.assertTrue((boolean)are.getMessage().contains("net.sf.myproject.module.SupportModuleC"));
        }
    }

    @Test
    public void testAsModuleDependencies() {
        Resource resource = loader.getResource(SIMPLE_SIMPLEMODULE_PROPERTIES);
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        List deps = mp.getDependencies();
        Assert.assertNotNull((Object)deps);
        Assert.assertEquals((long)3L, (long)deps.size());
        for (ModulePackageDependency dependency : deps) {
            String id = dependency.getId();
            Assert.assertTrue((boolean)id.startsWith("net.sf.myproject.module.SupportModule"));
            Assert.assertTrue((id.endsWith("A") || id.endsWith("B") || id.endsWith("C") ? 1 : 0) != 0);
            Assert.assertNull((Object)dependency.getVersionRange());
        }
    }
}

