/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.alfresco.web.site.servlet.AIMSFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class AIMSFilterTest {
    private static final String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjIxNDc0ODM2NDcsImp0aSI6IjEyMzQiLCJpc3MiOiJodHRwczovL215Lmlzc3VlciIsInN1YiI6ImFiYzEyMyIsInR5cCI6IkJlYXJlciIsInByZWZlcnJlZF91c2VybmFtZSI6Im1vaGluaXNoc2FoIn0.YOvsLAZ0ZyKf4igvtBY0fsO6R1F3Xhz5IsWzsRhyOVY";
    private static final String EXPECTED_AUDIENCE = "expected-audience";

    @Test
    public void shouldNotValidateWhenIssuerAndRequiredIssuerNotEqual() {
        AIMSFilter.JwtAudienceValidator audienceValidator = new AIMSFilter.JwtAudienceValidator(EXPECTED_AUDIENCE);
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"test_registration_id").authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId("test_client_id").redirectUri("test_uri_template").issuerUri("https://my.actualIssuer").authorizationUri("http://localhost:8999/auth").tokenUri("test_token_uri").build();
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        Jwt jwt = Jwt.withTokenValue((String)token).header("alg", (Object)"none").claim("sub", (Object)"abc123").claim("iss", (Object)"https://my.fakeIssuer").claim("preferred_username", (Object)"mohinishsah").build();
        OAuth2TokenValidatorResult oAuth2TokenValidatorResult = audienceValidator.validate(jwt);
        Assert.assertTrue((boolean)oAuth2TokenValidatorResult.hasErrors());
    }

    @Test
    public void shouldValidateWhenIssuerAndRequiredIssuerAreEqual() {
        AIMSFilter.JwtAudienceValidator audienceValidator = new AIMSFilter.JwtAudienceValidator(EXPECTED_AUDIENCE);
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"test_registration_id").authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId("test_client_id").redirectUri("test_uri_template").issuerUri("https://my.issuer").authorizationUri("http://localhost:8999/auth").tokenUri("test_token_uri").build();
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        Jwt jwt = Jwt.withTokenValue((String)token).header("alg", (Object)"none").claim("sub", (Object)"abc123").claim("iss", (Object)"https://my.issuer").claim("preferred_username", (Object)"mohinishsah").audience(List.of(EXPECTED_AUDIENCE)).build();
        OAuth2TokenValidatorResult oAuth2TokenValidatorResult = audienceValidator.validate(jwt);
        Assert.assertFalse((boolean)oAuth2TokenValidatorResult.hasErrors());
    }

    @Test
    public void shouldFailWithNullAudience() {
        AIMSFilter.JwtAudienceValidator audienceValidator = new AIMSFilter.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(null));
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assert.assertTrue((boolean)error.getDescription().contains(EXPECTED_AUDIENCE));
    }

    @Test
    public void shouldSucceedWithMatchingAudienceList() {
        AIMSFilter.JwtAudienceValidator audienceValidator = new AIMSFilter.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(List.of(EXPECTED_AUDIENCE)));
        Assert.assertFalse((boolean)validationResult.hasErrors());
        Assert.assertTrue((boolean)validationResult.getErrors().isEmpty());
    }

    @Test
    public void shouldSucceedWithMatchingSingleAudience() {
        AIMSFilter.JwtAudienceValidator audienceValidator = new AIMSFilter.JwtAudienceValidator(EXPECTED_AUDIENCE);
        Jwt token = Jwt.withTokenValue((String)UUID.randomUUID().toString()).claim("aud", (Object)EXPECTED_AUDIENCE).header("JUST", (Object)"FOR TESTING").build();
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(token);
        Assert.assertFalse((boolean)validationResult.hasErrors());
        Assert.assertTrue((boolean)validationResult.getErrors().isEmpty());
    }

    private Jwt tokenWithAudience(Collection<String> audience) {
        return Jwt.withTokenValue((String)UUID.randomUUID().toString()).audience(audience).header("JUST", (Object)"FOR TESTING").build();
    }
}

