/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.web.site.SlingshotPageView;
import org.alfresco.web.site.servlet.MTAuthenticationFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.mvc.PageViewResolver;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class SlingshotPageViewResolver
extends PageViewResolver {
    protected static final String URI_SITE = "site";
    protected static final String URI_PAGEID = "pageid";
    protected static final Pattern REGEX_PATTERN_SITE_ROOT = Pattern.compile("site\\/((\\w|-)+)\\/?$");
    protected static final String PAGE_ID_SITE_ROOT = "site-redirect";

    protected Page lookupPage(String pageId) {
        Page page;
        HttpServletRequest req;
        if (ThreadLocalRequestContext.getRequestContext().getUser() == null && (req = MTAuthenticationFilter.getCurrentServletRequest()) != null) {
            try {
                RequestContextUtil.initRequestContext((ApplicationContext)this.getApplicationContext(), (HttpServletRequest)req);
            }
            catch (RequestContextException e) {
                throw new PlatformRuntimeException("Failed to init Request Context: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((page = ThreadLocalRequestContext.getRequestContext().getPage()) != null) {
            return page;
        }
        return super.lookupPage(pageId);
    }

    protected AbstractUrlBasedView buildView(String viewName) {
        SlingshotPageView view = null;
        Page page = ThreadLocalRequestContext.getRequestContext().getPage();
        if (page != null) {
            view = new SlingshotPageView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
            view.setUrl(viewName);
            view.setPage(page);
            view.setUriTokens(ThreadLocalRequestContext.getRequestContext().getUriTokens());
            view.setUrlHelperFactory(this.getUrlHelperFactory());
        }
        return view;
    }

    protected Map<String, String> getTokens(String viewName) {
        Matcher matcher = REGEX_PATTERN_SITE_ROOT.matcher(viewName);
        if (matcher.matches()) {
            HashMap<String, String> tokens = new HashMap<String, String>(4);
            tokens.put(URI_SITE, matcher.group(1));
            tokens.put(URI_PAGEID, PAGE_ID_SITE_ROOT);
            return tokens;
        }
        return super.getTokens(viewName);
    }
}

