/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.scripts.SingletonValueProcessorExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;

public class QuickShareStatus
extends SingletonValueProcessorExtension<Boolean>
implements Serializable {
    private static Log logger = LogFactory.getLog(QuickShareStatus.class);

    public boolean getEnabled() {
        return (Boolean)this.getSingletonValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean retrieveValue(String userId, String storeId) throws ConnectorServiceException {
        boolean enabled = false;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", userId, ServletUtil.getSession());
        Response response = conn.call("/quickshare/enabled");
        if (response.getStatus().getCode() != 200) throw new AlfrescoRuntimeException("Unable to retrieve quick share information from Alfresco: " + response.getStatus().getCode());
        logger.info((Object)"Successfully retrieved quick share information from Alfresco.");
        try {
            JSONObject json = new JSONObject(response.getResponse());
            if (!json.has("enabled")) return enabled;
            enabled = json.getBoolean("enabled");
            return enabled;
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getValueName() {
        return "Quick Share enabled";
    }
}

