/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import org.alfresco.web.resolver.doclib.DoclistActionGroupResolver;
import org.alfresco.web.resolver.doclib.DoclistDataUrlResolver;
import org.alfresco.web.scripts.ActionEvaluatorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.processor.BaseProcessorExtension;

public class ResolverHelper
extends BaseProcessorExtension
implements ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ActionEvaluatorHelper.class);
    protected ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public DoclistDataUrlResolver getDoclistDataUrlResolver(String resolverName) {
        try {
            DoclistDataUrlResolver resolver = (DoclistDataUrlResolver)this.applicationContext.getBean(resolverName);
            if (resolver == null) {
                logger.warn((Object)("Bean with id '" + resolverName + "' does not implement DoclistDataUrlResolver interface."));
                return null;
            }
            return resolver;
        }
        catch (Exception e) {
            logger.warn((Object)("DoclistDataUrlResolver '" + resolverName + "' not found."));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exception when trying to get doclistDataUrlResolver '" + resolverName + "':"), (Throwable)e);
            }
            return null;
        }
    }

    public DoclistActionGroupResolver getDoclistActionGroupResolver(String resolverName) {
        try {
            DoclistActionGroupResolver resolver = (DoclistActionGroupResolver)this.applicationContext.getBean(resolverName);
            if (resolver == null) {
                logger.warn((Object)("Bean with id '" + resolverName + "' does not implement DoclistActionGroupResolver interface."));
                return null;
            }
            return resolver;
        }
        catch (Exception e) {
            logger.warn((Object)("DoclistActionGroupResolver '" + resolverName + "' not found."));
            return null;
        }
    }
}

