/**
 * Copyright (C) 2005-2015 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * This widget generates a colour drop down and it is expected that an instance of 
 * it be generated by a widget such as a button.
 * 
 * @module cmm/forms/controls/ColorPickerDropDown
 * @extends module:dijit/_WidgetBase
 * @mixes module:dijit/_TemplatedMixin
 * @mixes module:alfresco/core/CoreWidgetProcessing
 * @author Richard Smith
 */
define(["dojo/_base/declare",
        "dijit/_WidgetBase", 
        "dijit/_TemplatedMixin",
        "alfresco/core/CoreWidgetProcessing",
        "dojox/widget/ColorPicker",
        "alfresco/buttons/AlfButton",
        "dojo/text!./templates/ColorPickerDropDown.html",
        "dojo/_base/lang"],
        function(declare, _WidgetBase, _TemplatedMixin, CoreWidgetProcessing, ColorPicker, AlfButton, template, lang) {

   return declare([_WidgetBase, _TemplatedMixin, CoreWidgetProcessing], {

      /**
       * An array of the i18n files to use with this widget.
       *
       * @instance
       * @type {Array}
       * @default [{i18nFile:"./i18n/ColorPickerDropDown.properties"}]
       */
      i18nRequirements: [{i18nFile: "./i18n/ColorPickerDropDown.properties"}],
      
      /**
       * An array of the CSS files to use with this widget.
       * 
       * @instance
       * @type {object[]}
       * @default [
            {cssFile:"dojox/widget/ColorPicker/ColorPicker.css"},
            {cssFile:"./css/ColorPickerDropDown.css"}
         ]
       */
      cssRequirements: [
         {cssFile:"dojox/widget/ColorPicker/ColorPicker.css"},
         {cssFile:"./css/ColorPickerDropDown.css"}
      ],

      /**
       * The HTML template to use for the widget.
       * @instance
       * @type {String}
       */
      templateString: template,

      /**
       * Include hsv controls on the picker?
       * @instance
       * @type {boolean}
       */
      showHsv: false,

      /**
       * Include rgb controls on the picker?
       * @instance
       * @type {boolean}
       */
      showRgb: false,

      /**
       * Constraint to web safe colours on the picker?
       * @instance
       * @type {boolean}
       */
      webSafe: false,

      /**
       * @instance
       */
      postCreate: function cmm_forms_controls_ColorPickerDropDown__postCreate() {

         // Create a ColorPicker
         this.picker = new ColorPicker({
            animatePoint: false,
            showHsv: this.showHsv,
            showRgb: this.showRgb,
            webSafe: this.webSafe,
            onChange: lang.hitch(this, this.onChange)
         }, this._colorPickerNode);

         // Set the value
         if (this.value && this.value.match(/^#([0-9a-f]{3}|[0-9a-f]{6})$/i)){
            this.picker.setColor(this.value.trim());
         }

         // Create the buttons that control the colour selection
         var buttonWidgets = [{
            name: "alfresco/layout/LeftAndRight",
            config: {
               widgets: [
                  {
                     name: "alfresco/buttons/AlfButton",
                     align: "right",
                     config: {
                        label: "button.label.cancel",
                        onClick: lang.hitch(this, this.onCancel)
                     }
                  },
                  {
                     name: "alfresco/buttons/AlfButton",
                     align: "right",
                     config: {
                        label: "button.label.nocolor",
                        onClick: lang.hitch(this, this.onClear)
                     }
                  },
                  {
                     name: "alfresco/buttons/AlfButton",
                     align: "right",
                     config: {
                        label: "button.label.select",
                        onClick: lang.hitch(this, this.onSelect)
                     }
                  }
               ]
            }
         }];

         this.processWidgets(buttonWidgets, this._controlButtonsNode);
         this.inherited(arguments);
      },
      
      /**
       * Extension point for the select button
       * @instance
       */
      onSelect: function cmm_forms_controls_ColorPickerDropDown__onSelect() {
         
      },
      
      /**
       * Extension point for the cancel button
       * @instance
       */
      onCancel: function cmm_forms_controls_ColorPickerDropDown__onCancel() {
         
      },
      
      /**
       * Extension point for the clear button
       * @instance
       */
      onClear: function cmm_forms_controls_ColorPickerDropDown__onClear() {
         
      }
      
   });
});