/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.Response;

public abstract class ServiceBasedEvaluator
implements Evaluator {
    protected static final String ENDPOINT_ID = "alfresco";

    protected abstract Log getLogger();

    protected String callService(String serviceUrl) throws ConnectorServiceException {
        HttpSession currentSession;
        RequestContext requestContext;
        String currentUserId;
        StringBuilder builder = new StringBuilder().append("forms.cache.").append(serviceUrl);
        String keyForCachedJson = builder.toString();
        Map valuesMap = ThreadLocalRequestContext.getRequestContext().getValuesMap();
        Serializable cachedResult = (Serializable)valuesMap.get(keyForCachedJson);
        if (cachedResult != null & cachedResult instanceof String) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Retrieved cached response for " + serviceUrl));
            }
            return (String)((Object)cachedResult);
        }
        ConnectorService connService = FrameworkUtil.getConnectorService();
        Connector connector = connService.getConnector(ENDPOINT_ID, currentUserId = (requestContext = ThreadLocalRequestContext.getRequestContext()).getUserId(), currentSession = ServletUtil.getSession((boolean)true));
        Response r = connector.call(serviceUrl);
        if (r.getStatus().getCode() == 401) {
            throw new NotAuthenticatedException();
        }
        String jsonResponseString = r.getResponse();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Caching response for " + serviceUrl + ":\n" + jsonResponseString));
        }
        ThreadLocalRequestContext.getRequestContext().setValue(keyForCachedJson, (Serializable)((Object)jsonResponseString));
        return jsonResponseString;
    }

    class NotAuthenticatedException
    extends RuntimeException {
        private static final long serialVersionUID = -4906852539344031273L;

        NotAuthenticatedException() {
        }
    }
}

