/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.web.util.UriComponentsBuilder;

public class AIMSConfig {
    private static final Log LOGGER = LogFactory.getLog(AIMSConfig.class);
    private boolean enabled;
    private String realm;
    private String resource;
    private String secret;
    private String authServerUrl;
    private String sslRequired;
    private String principalAttribute;
    private ConfigService configService;
    private boolean alwaysRefreshToken;
    private String audience;
    private Boolean publicClient;
    private String redirectURI;
    private String logoutUri;
    private String postLogoutUrl;
    private Boolean userIdTokenHint;
    private String postLogoutRedirectUrlLabel;
    private String postLogoutRedirectUrlValue;
    private String logoutClientIDLabel;
    private String logoutClientIDValue;
    private static final String REALMS = "realms";
    private static final String DEFAULT_SCOPES = "openid,profile,email";
    private String shareContext;
    private String atIssuerAttribute;
    private Set<String> scopes;

    public void init() {
        Config config = this.configService.getConfig((Object)"AIMS");
        this.setEnabled(Boolean.parseBoolean(config.getConfigElement("enabled").getValue()));
        this.setRealm(config.getConfigElementValue("realm"));
        this.setResource(config.getConfigElementValue("resource"));
        this.setAuthServerUrl(config.getConfigElementValue("authServerUrl"));
        this.setSslRequired(config.getConfigElementValue("sslRequired"));
        this.setPublicClient(Boolean.valueOf(Boolean.parseBoolean(config.getConfigElement("publicClient").getValue())));
        this.setAudience(config.getConfigElementValue("audience"));
        this.setScopes(config.getConfigElementValue("scopes"));
        this.setAtIssuerAttribute(config.getConfigElementValue("atIssuerAttribute"));
        if (this.publicClient.booleanValue()) {
            this.setSecret(null);
        } else if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("secret"))) {
            this.setSecret(config.getConfigElementValue("secret"));
        } else {
            OAuth2Error oauth2Error = new OAuth2Error("Missing secret-key value. Please provide a Secret Key");
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("principalAttribute"))) {
            this.setPrincipalAttribute(config.getConfigElementValue("principalAttribute"));
        } else {
            this.setPrincipalAttribute("preferred_username");
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("alwaysRefreshToken"))) {
            this.setAlwaysRefreshToken(Boolean.parseBoolean(config.getConfigElement("alwaysRefreshToken").getValue()));
        } else {
            this.setAlwaysRefreshToken(false);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("redirectURI"))) {
            this.setRedirectURI(config.getConfigElement("redirectURI").getValue());
        } else {
            this.setRedirectURI(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("logoutUri"))) {
            this.setLogoutUri(config.getConfigElement("logoutUri").getValue());
        } else {
            this.setLogoutUri(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("useIdTokenHint"))) {
            this.setUserIdTokenHint(Boolean.valueOf(Boolean.parseBoolean(config.getConfigElement("useIdTokenHint").getValue())));
        } else {
            this.setUserIdTokenHint(Boolean.valueOf(true));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("postLogoutRedirectUrlValue"))) {
            this.setPostLogoutRedirectUrlValue(config.getConfigElementValue("postLogoutRedirectUrlValue"));
        } else {
            this.setPostLogoutRedirectUrlValue(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("postLogoutRedirectUrlLabel"))) {
            this.setPostLogoutRedirectUrlLabel(config.getConfigElementValue("postLogoutRedirectUrlLabel"));
        } else {
            this.setPostLogoutRedirectUrlLabel(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("logoutClientIDLabel"))) {
            this.setLogoutClientIDLabel(config.getConfigElementValue("logoutClientIDLabel"));
        } else {
            this.setLogoutClientIDLabel(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("logoutClientIDValue"))) {
            this.setLogoutClientIDValue(config.getConfigElementValue("logoutClientIDValue"));
        } else {
            this.setLogoutClientIDValue(null);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getConfigElementValue("shareContext"))) {
            this.setShareContext(config.getConfigElementValue("shareContext"));
        } else {
            this.setShareContext("/share");
        }
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getAuthServerUrl() {
        return Optional.ofNullable(this.realm).filter(StringUtils::isNotBlank).filter(realm -> StringUtils.isNotBlank((CharSequence)this.authServerUrl)).map(realm -> UriComponentsBuilder.fromUriString((String)this.authServerUrl).pathSegment(new String[]{REALMS, realm}).build().toString()).orElse(this.authServerUrl);
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public String getSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(String sslRequired) {
        this.sslRequired = sslRequired;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public Boolean getPublicClient() {
        return this.publicClient;
    }

    public void setPublicClient(Boolean publicClient) {
        this.publicClient = publicClient;
    }

    public boolean isAlwaysRefreshToken() {
        return this.alwaysRefreshToken;
    }

    public void setAlwaysRefreshToken(boolean alwaysRefreshToken) {
        this.alwaysRefreshToken = alwaysRefreshToken;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public String getPostLogoutUrl() {
        return this.postLogoutUrl;
    }

    public void setPostLogoutUrl(String postLogoutUrl) {
        this.postLogoutUrl = postLogoutUrl;
    }

    public Boolean getUserIdTokenHint() {
        return this.userIdTokenHint;
    }

    public void setUserIdTokenHint(Boolean userIdTokenHint) {
        this.userIdTokenHint = userIdTokenHint;
    }

    public String getPostLogoutRedirectUrlLabel() {
        return this.postLogoutRedirectUrlLabel;
    }

    public void setPostLogoutRedirectUrlLabel(String postLogoutRedirectUrlLabel) {
        this.postLogoutRedirectUrlLabel = postLogoutRedirectUrlLabel;
    }

    public String getLogoutClientIDLabel() {
        return this.logoutClientIDLabel;
    }

    public void setLogoutClientIDLabel(String logoutClientIDLabel) {
        this.logoutClientIDLabel = logoutClientIDLabel;
    }

    public String getPostLogoutRedirectUrlValue() {
        return this.postLogoutRedirectUrlValue;
    }

    public void setPostLogoutRedirectUrlValue(String postLogoutRedirectUrlValue) {
        this.postLogoutRedirectUrlValue = postLogoutRedirectUrlValue;
    }

    public String getLogoutClientIDValue() {
        return this.logoutClientIDValue;
    }

    public void setLogoutClientIDValue(String logoutClientIDValue) {
        this.logoutClientIDValue = logoutClientIDValue;
    }

    public String getShareContext() {
        return this.shareContext;
    }

    public void setShareContext(String shareContext) {
        this.shareContext = shareContext;
    }

    public void setScopes(String scopes) {
        this.scopes = Stream.of(Optional.ofNullable(scopes).filter(StringUtils::isNotBlank).orElse(DEFAULT_SCOPES).split(",")).map(String::trim).collect(Collectors.toUnmodifiableSet());
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getAtIssuerAttribute() {
        return this.atIssuerAttribute;
    }

    public void setAtIssuerAttribute(String atIssuerAttribute) {
        this.atIssuerAttribute = atIssuerAttribute;
    }
}

