/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.web.site.servlet.AIMSLogoutHandler;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.web.RedirectStrategy;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AIMSLogoutHandlerTest {
    ClientRegistration clientRegistration;
    @Mock
    ClientRegistrationRepository clientRegistrationRepository;
    @Mock
    AIMSLogoutHandler logoutHandler;
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;
    @Mock
    Authentication authentication;
    @Mock
    AIMSConfig aimsConfig;
    @Mock
    RedirectStrategy redirectStrategy;
    Map<String, Object> endpointMap;

    @Before
    public void setup() {
        this.endpointMap = new HashMap<String, Object>();
        this.endpointMap.put("end_session_endpoint", "http://localhost:8080");
        this.request = new MockHttpServletRequest("POST", "http://localhost:8080/share/page/dashboard");
    }

    @Test
    public void getTargetUrlWhenLogoutUriIsNull() throws ServletException, IOException {
        Mockito.when((Object)this.aimsConfig.getResource()).thenReturn((Object)"alfresco");
        Mockito.when((Object)this.aimsConfig.getLogoutClientIDLabel()).thenReturn((Object)"alfresco");
        Mockito.when((Object)this.aimsConfig.getLogoutClientIDValue()).thenReturn((Object)"alfresco");
        ((RedirectStrategy)Mockito.doNothing().when((Object)this.redirectStrategy)).sendRedirect((HttpServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        this.clientRegistration = ClientRegistration.withRegistrationId((String)"alfresco").authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId("alfresco").redirectUri("http://localhost:8080/share/page/dashboard").authorizationUri("http://localhost:8999/auth").tokenUri("tokenuri").providerConfigurationMetadata(this.endpointMap).build();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId(ArgumentMatchers.anyString())).thenReturn((Object)this.clientRegistration);
        ((AIMSLogoutHandler)Mockito.doNothing().when((Object)this.logoutHandler)).handle(this.request, this.response, this.authentication);
        this.logoutHandler.handle(this.request, this.response, this.authentication);
        ((AIMSLogoutHandler)Mockito.verify((Object)this.logoutHandler, (VerificationMode)Mockito.times((int)1))).handle(this.request, this.response, this.authentication);
    }

    @Test
    public void getTargetUrlWhenLogoutUriAndPostLogoutUriIsNotNull() throws ServletException, IOException {
        Mockito.when((Object)this.aimsConfig.getResource()).thenReturn((Object)"alfresco");
        Mockito.when((Object)this.aimsConfig.getLogoutUri()).thenReturn((Object)"http://localhost:8999/auth");
        this.endpointMap.put("post_redirect_uri", "http://localhost:8999/auth");
        this.clientRegistration = ClientRegistration.withRegistrationId((String)"123").authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId("alfresco").redirectUri("http://localhost:8080/share/page/dashboard").authorizationUri("http://localhost:8999/auth").tokenUri("tokenuri").providerConfigurationMetadata(this.endpointMap).build();
        Mockito.when((Object)this.aimsConfig.getLogoutClientIDLabel()).thenReturn((Object)"client_id");
        Mockito.when((Object)this.aimsConfig.getLogoutClientIDValue()).thenReturn((Object)"alfresco");
        Mockito.when((Object)this.aimsConfig.getPostLogoutRedirectUrlLabel()).thenReturn((Object)"post_logout_redirect_uri");
        Mockito.when((Object)this.aimsConfig.getPostLogoutRedirectUrlValue()).thenReturn((Object)"http://localhost:8999/auth");
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId(ArgumentMatchers.anyString())).thenReturn((Object)this.clientRegistration);
        ((RedirectStrategy)Mockito.doNothing().when((Object)this.redirectStrategy)).sendRedirect((HttpServletRequest)ArgumentMatchers.any(), (HttpServletResponse)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        ((AIMSLogoutHandler)Mockito.doNothing().when((Object)this.logoutHandler)).handle(this.request, this.response, this.authentication);
        this.logoutHandler.handle(this.request, this.response, this.authentication);
        ((AIMSLogoutHandler)Mockito.verify((Object)this.logoutHandler, (VerificationMode)Mockito.times((int)1))).handle(this.request, this.response, this.authentication);
    }

    @Test
    public void getTargetUrlWhenClientRegistrationIsNull() throws ServletException, IOException {
        Mockito.when((Object)this.aimsConfig.getResource()).thenReturn((Object)"123");
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId(ArgumentMatchers.anyString())).thenReturn(null);
        ((AIMSLogoutHandler)Mockito.doNothing().when((Object)this.logoutHandler)).handle(this.request, this.response, this.authentication);
        this.logoutHandler.handle(this.request, this.response, this.authentication);
        ((AIMSLogoutHandler)Mockito.verify((Object)this.logoutHandler, (VerificationMode)Mockito.times((int)1))).handle(this.request, this.response, this.authentication);
    }
}

