/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minidev.json.JSONObject;
import org.alfresco.web.site.TaskUtils;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.alfresco.web.site.servlet.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class AppConfig {
    private static final Log LOGGER = LogFactory.getLog(AppConfig.class);
    private final String clientId;
    private final String clientSecret;
    private final String principalAttribute;
    private final AIMSConfig aimsConfig;
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> typeReference = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public AppConfig(AIMSConfig aimsConfig) {
        this.aimsConfig = aimsConfig;
        this.clientId = aimsConfig.getResource();
        this.clientSecret = aimsConfig.getSecret();
        this.principalAttribute = aimsConfig.getPrincipalAttribute();
    }

    @Bean
    public OAuth2AuthorizedClientRepository authorizedClientRepository(@Autowired(required=false) OAuth2AuthorizedClientService authorizedClientService) {
        if (null != authorizedClientService) {
            return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
        }
        return null;
    }

    @Bean
    public OAuth2AuthorizedClientService authorizedClientService(@Autowired(required=false) ClientRegistrationRepository clientRegistrationRepository) {
        if (null != clientRegistrationRepository) {
            return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
        }
        return null;
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        ClientRegistration clientRegistration = this.clientRegistration();
        if (null != clientRegistration) {
            return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
        }
        return null;
    }

    @Bean
    public AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceAndManager(@Autowired(required=false) ClientRegistrationRepository clientRegistrationRepository, @Autowired(required=false) OAuth2AuthorizedClientService authorizedClientService) {
        if (null != clientRegistrationRepository && null != authorizedClientService) {
            OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().build();
            AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return authorizedClientManager;
        }
        return null;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter(builder.build());
        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);
        return jsonConverter;
    }

    private ClientRegistration clientRegistration() {
        if (this.aimsConfig.isEnabled()) {
            AtomicReference builder = new AtomicReference();
            TaskUtils.retry((int)10, (long)1000L, (Log)LOGGER, () -> builder.set(this.createBuilder(this.getMetadataURI())));
            return ((ClientRegistration.Builder)builder.get()).registrationId(this.clientId).clientId(this.clientId).clientSecret(this.clientSecret).scope(new String[]{"openid", "profile", "email"}).redirectUri("*").userNameAttributeName(this.principalAttribute).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientName(this.clientId).build();
        }
        return null;
    }

    private URI getMetadataURI() {
        String authServerUrl = this.aimsConfig.getAuthServerUrl();
        if (StringUtils.isEmpty((CharSequence)authServerUrl)) {
            throw new IllegalArgumentException("AuthServer Url cannot be empty.");
        }
        return UriComponentsBuilder.fromUriString((String)authServerUrl).pathSegment(new String[]{".well-known", "openid-configuration"}).build().toUri();
    }

    private ClientRegistration.Builder createBuilder(URI metaDataUri) {
        RequestEntity request = RequestEntity.get((URI)metaDataUri).build();
        Map configuration = (Map)rest.exchange(request, typeReference).getBody();
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)AppConfig.parse((Map)configuration, OIDCProviderMetadata::parse);
        String authUri = Optional.of(metadata).map(AuthorizationServerEndpointMetadata::getAuthorizationEndpointURI).map(URI::toASCIIString).orElse(null);
        String issuerUri = Optional.of(metadata).map(AuthorizationServerMetadata::getIssuer).map(Identifier::getValue).orElseThrow(() -> new IllegalStateException("Issuer Url cannot be empty."));
        LinkedHashMap configurationMetadata = new LinkedHashMap(metadata.toJSONObject());
        return ClientRegistration.withRegistrationId((String)"ids").providerConfigurationMetadata(configurationMetadata).authorizationUri(authUri).issuerUri(issuerUri).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString());
    }

    private static <T> T parse(Map<String, Object> body, ThrowingFunction<JSONObject, T, ParseException> parser) {
        try {
            return (T)parser.apply((Object)new JSONObject(body));
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }
}

