/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.scripts.ShareManifest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ShareManifestTest {
    private ShareManifest shareManifest;
    private File manifestFile;

    @Before
    public void setUp() throws Exception {
        this.manifestFile = File.createTempFile("Manifest-Test", "MF");
        this.manifestFile.deleteOnExit();
        try (PrintWriter pw = new PrintWriter(this.manifestFile);){
            pw.println("First-Attr: Red");
            pw.println("Second-Attr: Green");
            pw.println("");
            pw.println("Name: Meals");
            pw.println("Dinner: Fish and chips");
            pw.println("Lunch: Pizza");
            pw.println("Breakfast: Toast");
        }
        this.shareManifest = new ShareManifest((Resource)new FileSystemResource(this.manifestFile));
        this.shareManifest.readManifest();
    }

    @Test
    public void canGetMainAttributeNames() {
        List attrNames = this.shareManifest.mainAttributeNames();
        Assert.assertEquals((long)2L, (long)attrNames.size());
        Assert.assertTrue((boolean)attrNames.contains("First-Attr"));
        Assert.assertTrue((boolean)attrNames.contains("Second-Attr"));
    }

    @Test
    public void canGetMainAttributes() {
        Assert.assertEquals((Object)"Red", (Object)this.shareManifest.mainAttributeValue("First-Attr"));
        Assert.assertEquals((Object)"Green", (Object)this.shareManifest.mainAttributeValue("Second-Attr"));
        Assert.assertNull((Object)this.shareManifest.mainAttributeValue("Dinner"));
    }

    @Test
    public void canGetMainAttributesMap() {
        Map map = this.shareManifest.mainAttributesMap();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Red", map.get("First-Attr"));
        Assert.assertEquals((Object)"Green", map.get("Second-Attr"));
    }

    @Test
    public void canGetAllSectionNames() {
        Set sections = this.shareManifest.sectionNames();
        Assert.assertEquals((long)1L, (long)sections.size());
        Assert.assertTrue((boolean)sections.contains("Meals"));
    }

    @Test
    public void canGetNamedSectionAttributeNames() {
        List attrNames = this.shareManifest.attributeNames("Meals");
        Assert.assertEquals((long)3L, (long)attrNames.size());
        Assert.assertTrue((boolean)attrNames.contains("Breakfast"));
        Assert.assertTrue((boolean)attrNames.contains("Lunch"));
        Assert.assertTrue((boolean)attrNames.contains("Dinner"));
    }

    @Test
    public void canGetNamedSectionAttributeValue() {
        Assert.assertEquals((Object)"Fish and chips", (Object)this.shareManifest.attributeValue("Meals", "dinner"));
        Assert.assertEquals((Object)"Pizza", (Object)this.shareManifest.attributeValue("Meals", "lunch"));
        Assert.assertEquals((Object)"Toast", (Object)this.shareManifest.attributeValue("Meals", "breakfast"));
    }

    @Test
    public void canGetNamedSectionAttributesMap() {
        Map map = this.shareManifest.attributesMap("Meals");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Fish and chips", map.get("Dinner"));
        Assert.assertEquals((Object)"Pizza", map.get("Lunch"));
        Assert.assertEquals((Object)"Toast", map.get("Breakfast"));
    }

    @Test
    public void doesntGetVersion() {
        String version;
        try {
            version = this.shareManifest.getSpecificationVersion();
            Assert.fail((String)"should throw the error");
        }
        catch (AlfrescoRuntimeException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Share Specification-Version is missing"));
            Assert.assertTrue((boolean)expected.getMessage().contains("Invalid MANIFEST.MF"));
        }
        try {
            version = this.shareManifest.getImplementationVersion();
            Assert.fail((String)"should throw the error");
        }
        catch (AlfrescoRuntimeException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Share Implementation-Version is missing"));
            Assert.assertTrue((boolean)expected.getMessage().contains("Invalid MANIFEST.MF"));
        }
    }

    @Test
    public void canHandleMissingSection() {
        List noNames = this.shareManifest.attributeNames("Missing");
        Assert.assertTrue((boolean)noNames.isEmpty());
    }
}

