/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.web.site.servlet.AIMSLogoutHandler;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.mvc.LogoutController;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AIMSLogoutController
extends AbstractController {
    protected AIMSConfig config;
    protected LogoutController logoutController;
    private ApplicationContext applicationContext;
    private AIMSLogoutHandler aimsLogoutHandler;

    public void setConfig(AIMSConfig config) {
        this.config = config;
    }

    public void setLogoutController(LogoutController logoutController) {
        this.logoutController = logoutController;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.config.isEnabled()) {
            if (request.getParameter("success") != null) {
                this.logoutController.handleRequestInternal(request, response);
                this.doRedirect(response, request.getContextPath());
            } else {
                SecurityContext account;
                String userId;
                this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)super.getServletContext());
                this.aimsLogoutHandler = (AIMSLogoutHandler)this.applicationContext.getBean(AIMSLogoutHandler.class);
                HttpSession session = request.getSession(false);
                if (session != null && (userId = (String)session.getAttribute("_alf_USER_ID")) != null && (account = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")) != null) {
                    try {
                        this.aimsLogoutHandler.handle(request, response, account.getAuthentication());
                    }
                    catch (IOException | ServletException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return null;
    }

    protected void doRedirect(HttpServletResponse response, String location) {
        response.setStatus(301);
        response.setHeader("Location", location);
        response.setHeader("Cache-Control", "max-age=0");
    }
}

