/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.alfresco.web.site.SlingshotUser;
import org.alfresco.web.site.servlet.SlingshotLoginController;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AlfrescoUser;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.AlfrescoUserFactory;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class SlingshotUserFactory
extends AlfrescoUserFactory {
    public static final String ALF_USER_LOADED = "alfUserLoaded";
    public static final String ALF_USER_GROUPS = "alfUserGroups";
    public static final String CM_USERSTATUS = "{http://www.alfresco.org/model/content/1.0}userStatus";
    public static final String CM_USERSTATUSTIME = "{http://www.alfresco.org/model/content/1.0}userStatusTime";
    public static final String CM_USERHOME = "{http://www.alfresco.org/model/content/1.0}homeFolder";
    public static final String PROP_USERSTATUS = "userStatus";
    public static final String PROP_USERSTATUSTIME = "userStatusTime";
    public static final String PROP_USERHOME = "userHome";
    public static final String CM_PREFERENCEVALUES = "{http://www.alfresco.org/model/content/1.0}preferenceValues";
    public static final String PROP_USERHOMEPAGE = "userHomePage";
    public static final String PREFERENCE_USERHOMEPAGE = "org.alfresco.share.user.homePage";
    public static final String ACTIVITI_ADMIN_ENDPOINT_ID = "activiti-admin";

    public boolean authenticate(HttpServletRequest request, String username, String password) {
        boolean authenticated = false;
        if (!AuthenticationUtil.isGuest((String)username) && (authenticated = super.authenticate(request, username, password))) {
            CredentialVault vault = this.frameworkUtils.getCredentialVault(request.getSession(), username);
            Credentials credentials = vault.newCredentials(ACTIVITI_ADMIN_ENDPOINT_ID);
            credentials.setProperty("cleartextUsername", (Object)username);
            credentials.setProperty("cleartextPassword", (Object)password);
        }
        return authenticated;
    }

    protected AlfrescoUser constructUser(JSONObject properties, Map<String, Boolean> capabilities, Map<String, Boolean> immutability) throws JSONException {
        String preferenceValues;
        SlingshotUser user = new SlingshotUser(properties.getString("{http://www.alfresco.org/model/content/1.0}userName"), capabilities, immutability);
        user.setProperty(PROP_USERSTATUS, (Serializable)((Object)(properties.has(CM_USERSTATUS) ? properties.getString(CM_USERSTATUS) : null)));
        user.setProperty(PROP_USERSTATUSTIME, (Serializable)((Object)(properties.has(CM_USERSTATUSTIME) ? properties.getString(CM_USERSTATUSTIME) : null)));
        user.setProperty(PROP_USERHOME, (Serializable)((Object)(properties.has(CM_USERHOME) ? properties.getString(CM_USERHOME) : null)));
        if (properties.has(CM_PREFERENCEVALUES) && (preferenceValues = properties.getString(CM_PREFERENCEVALUES)).trim().length() != 0) {
            try {
                JSONObject preferences = new JSONObject(preferenceValues);
                String defaultPage = preferences.getString(PREFERENCE_USERHOMEPAGE);
                if (defaultPage != null && !defaultPage.trim().equals("")) {
                    user.setProperty(PROP_USERHOMEPAGE, (Serializable)((Object)defaultPage));
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return user;
    }

    public User loadUser(RequestContext context, String userId, String endpointId) throws UserFactoryException {
        String groups;
        User user = super.loadUser(context, userId, endpointId);
        user.setProperty(ALF_USER_LOADED, (Serializable)Long.valueOf(new Date().getTime()));
        HttpSession session = ServletUtil.getSession((boolean)false);
        if (session != null && (groups = (String)session.getAttribute(SlingshotLoginController.SESSION_ATTRIBUTE_KEY_USER_GROUPS)) != null) {
            user.setProperty(ALF_USER_GROUPS, (Serializable)((Object)groups));
        }
        return user;
    }

    public String getUserHomePage(RequestContext context, String userId) throws UserFactoryException {
        String userHomePage;
        Object homePage = "/page/user/" + URLEncoder.encode((String)userId) + "/dashboard";
        User user = context.getUser();
        if (user != null && (userHomePage = (String)user.getProperty(PROP_USERHOMEPAGE)) != null && !userHomePage.trim().equals("")) {
            homePage = userHomePage;
        }
        return homePage;
    }

    public void saveUser(AlfrescoUser user) throws UserFactoryException {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (!context.getUserId().equals(user.getId())) {
            throw new UserFactoryException("Unable to persist user with different Id that current Id.");
        }
        StringBuilderWriter buf = new StringBuilderWriter(512);
        JSONWriter writer = new JSONWriter((Writer)buf);
        try {
            writer.startObject();
            writer.writeValue("username", user.getId());
            writer.startValue("properties");
            writer.startObject();
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}firstName", user.getFirstName());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}lastName", user.getLastName());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}jobtitle", user.getJobTitle());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}organization", user.getOrganization());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}location", user.getLocation());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}email", user.getEmail());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}telephone", user.getTelephone());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}mobile", user.getMobilePhone());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}skype", user.getSkype());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}instantmsg", user.getInstantMsg());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}googleusername", user.getGoogleUsername());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companyaddress1", user.getCompanyAddress1());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companyaddress2", user.getCompanyAddress2());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companyaddress3", user.getCompanyAddress3());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companypostcode", user.getCompanyPostcode());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companyfax", user.getCompanyFax());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companyemail", user.getCompanyEmail());
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}companytelephone", user.getCompanyTelephone());
            writer.endObject();
            writer.endValue();
            writer.startValue("content");
            writer.startObject();
            writer.writeValue("{http://www.alfresco.org/model/content/1.0}persondescription", user.getBiography());
            writer.endObject();
            writer.endValue();
            writer.endObject();
            Connector conn = FrameworkUtil.getConnector((RequestContext)context, (String)"alfresco");
            ConnectorContext c = new ConnectorContext(HttpMethod.POST);
            c.setContentType("application/json");
            Response res = conn.call("/slingshot/profile/userprofile", c, (InputStream)new ByteArrayInputStream(buf.toString().getBytes()));
            if (200 != res.getStatus().getCode()) {
                throw new UserFactoryException("Remote error during User save: " + res.getStatus().getMessage());
            }
        }
        catch (IOException ioErr) {
            throw new UserFactoryException("IO error during User save: " + ioErr.getMessage(), (Exception)ioErr);
        }
        catch (ConnectorServiceException cse) {
            throw new UserFactoryException("Configuration error during User save: " + cse.getMessage(), (Exception)((Object)cse));
        }
    }
}

