/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.util.Objects;
import org.alfresco.event.outbox.AutodetectDbOutbox;
import org.alfresco.event.outbox.ConnectionSource;
import org.alfresco.event.outbox.DefaultEventProcessor;
import org.alfresco.event.outbox.EventConsumer;
import org.alfresco.event.outbox.EventTable;
import org.alfresco.event.outbox.EventTableOutbox;
import org.alfresco.event.outbox.MetricsAdapter;
import org.alfresco.event.outbox.Outbox;
import org.alfresco.event.outbox.OutboxConfig;
import org.alfresco.event.outbox.OutboxWorker;

public final class OutboxBuilder {
    private static final MetricsAdapter NOOP_METRICS = new MetricsAdapter(){};
    private static final OutboxConfig DEFAULT_CONFIG = new OutboxConfig(){};
    private static final EventConsumer NOOP_EVENT_CONSUMER = e -> {};
    private final ConnectionSource connectionSource;
    private MetricsAdapter metricsAdapter = NOOP_METRICS;
    private EventConsumer outboundEventConsumer = NOOP_EVENT_CONSUMER;
    private OutboxConfig config = DEFAULT_CONFIG;

    private OutboxBuilder(ConnectionSource connectionSource) {
        Objects.requireNonNull(connectionSource);
        this.connectionSource = connectionSource;
    }

    public static OutboxBuilder forAutodetectedDb(ConnectionSource connectionSource) {
        return new OutboxBuilder(connectionSource);
    }

    public OutboxBuilder withOutboundEventConsumer(EventConsumer outboundEventConsumer) {
        this.outboundEventConsumer = Objects.requireNonNull(outboundEventConsumer);
        return this;
    }

    public OutboxBuilder withMetricsAdapter(MetricsAdapter metricsAdapter) {
        this.metricsAdapter = Objects.requireNonNull(metricsAdapter);
        return this;
    }

    public OutboxBuilder withConfig(OutboxConfig config) {
        this.config = Objects.requireNonNull(config);
        return this;
    }

    public Outbox build() {
        return new AutodetectDbOutbox(this.connectionSource, this::createEventTableOutbox);
    }

    private EventTableOutbox createEventTableOutbox(EventTable eventTable) {
        DefaultEventProcessor eventProcessor = new DefaultEventProcessor(eventTable, this.connectionSource, this.outboundEventConsumer, this.metricsAdapter, this.config);
        OutboxWorker outboxWorker = new OutboxWorker(eventProcessor);
        return new EventTableOutbox(eventTable, outboxWorker, this.connectionSource, this.metricsAdapter, this.config);
    }
}

