/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface MetricsAdapter {
    default public void report(MetricId metricId, long number) {
    }

    default public void report(MetricId metricId, Duration duration) {
    }

    public static final class MetricId {
        private final String name;
        private final Map<String, String> tags;

        private MetricId(String name, Map<String, String> tags) {
            this.name = Objects.requireNonNull(name);
            this.tags = Objects.requireNonNull(tags);
        }

        public static MetricId from(String name, String ... tags) {
            if ((tags.length & 1) == 1) {
                throw new IllegalArgumentException("Number of tag args should be even.");
            }
            Map tagMap = IntStream.range(0, tags.length / 2).map(i -> i * 2).mapToObj(i -> Map.of(tags[i], tags[i + 1])).reduce(Map.of(), (m1, m2) -> new HashMap<String, String>(){
                {
                    this.putAll(m1);
                    this.putAll(m2);
                }
            });
            return new MetricId(name, Map.copyOf(tagMap));
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricId metricId = (MetricId)o;
            return Objects.equals(this.name, metricId.name) && Objects.equals(this.tags, metricId.tags);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.tags);
        }

        public String toString() {
            return this.name + this.tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

