/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.alfresco.event.outbox.EventTableStats;
import org.alfresco.event.outbox.InternalEvent;
import org.alfresco.event.outbox.OutboxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EventTable {
    private static final String SQL_PLACEHOLDER = "?";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTable.class);

    EventTable() {
    }

    public boolean isSchemaUpToDate(Connection connection) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), this.getTableName(), null);){
            if (rs.next()) {
                if (!rs.next()) {
                    boolean bl = true;
                    return bl;
                }
                LOGGER.error("More than one outbox table `{}` has been found.", (Object)this.getTableName());
                throw new OutboxException("More than one outbox table has been found.");
            }
            boolean bl = false;
            return bl;
        }
    }

    public void tryToMakeSchemaUpToDate(Connection connection) throws SQLException {
        SqlStatement createStatement = this.getCreateTableStatement();
        createStatement.execute(connection, s -> {
            LOGGER.info("Creating outbox table `{}`.", (Object)this.getTableName());
            s.executeUpdate();
            LOGGER.info("Outbox table has been created.");
            return null;
        });
    }

    public boolean insertEvent(Connection connection, InternalEvent event) throws SQLException {
        SqlStatement insertStatement = this.getInsertEventStatement(event);
        return insertStatement.execute(connection, s -> s.executeUpdate() == 1);
    }

    public List<InternalEvent> fetchEvents(Connection connection, int fetchLimit) throws SQLException {
        EventTable.requireValidFetchLimit(fetchLimit);
        SqlStatement fetchStatement = this.getFetchEventsStatement(fetchLimit);
        return fetchStatement.execute(connection, s -> {
            try (ResultSet rs = s.executeQuery();){
                ArrayList<InternalEvent> result = new ArrayList<InternalEvent>(Math.min(fetchLimit, 1024));
                while (rs.next()) {
                    long eventId = rs.getLong(this.getIdColumnName());
                    Instant receivedTime = rs.getTimestamp(this.getReceivedAtColumnName()).toInstant();
                    String eventData = rs.getString(this.getEventDataColumnName());
                    result.add(new InternalEvent(eventId, receivedTime, eventData));
                }
                ArrayList<InternalEvent> arrayList = result;
                return arrayList;
            }
        });
    }

    public long deleteEvents(Connection connection, List<Long> ids) throws SQLException {
        SqlStatement deleteStatement = this.getDeleteEventsStatement(connection, ids);
        return deleteStatement.execute(connection, PreparedStatement::executeLargeUpdate);
    }

    public EventTableStats getStats(Connection connection) throws SQLException {
        SqlStatement statsStatement = this.getStatsStatement();
        return statsStatement.execute(connection, s -> {
            try (ResultSet rs = s.executeQuery();){
                if (!rs.next()) {
                    EventTableStats eventTableStats = new EventTableStats(Instant.now(), 0L, Duration.ZERO);
                    return eventTableStats;
                }
                long size = rs.getLong(1);
                Timestamp oldestEventReceiveTime = rs.getTimestamp(2);
                EventTableStats eventTableStats = new EventTableStats(Instant.now(), size, Optional.ofNullable(oldestEventReceiveTime).map(Timestamp::toInstant).map(i -> Duration.between(i, Instant.now())).orElse(Duration.ZERO));
                return eventTableStats;
            }
        });
    }

    protected SqlStatement prepareStatementForMultipleParams(List<Long> ids, String sqlTemplate, String tagToReplace) {
        SqlStatement.StatementPreparer[] preparersArray = (SqlStatement.StatementPreparer[])IntStream.range(0, ids.size()).mapToObj(index -> s -> s.setLong(index + 1, (Long)ids.get(index))).toArray(SqlStatement.StatementPreparer[]::new);
        String statementString = this.prepareSQLTemplateWithQuestionMarks(sqlTemplate, tagToReplace, ids.size());
        return SqlStatement.create(statementString, preparersArray);
    }

    protected long divideIntoBatchesAndExecute(List<Long> ids, int batchSize, SQLFunction<List<Long>, Long> action) throws SQLException {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be positive" + batchSize);
        }
        long totalCount = 0L;
        for (int index = 0; index < ids.size(); index += batchSize) {
            int end = Math.min(index + batchSize, ids.size());
            List<Long> batch = ids.subList(index, end);
            totalCount += action.apply(batch).longValue();
        }
        return totalCount;
    }

    protected String prepareSQLTemplateWithQuestionMarks(String sqlTemplate, String tagToReplace, int questionMarkCount) {
        Objects.requireNonNull(sqlTemplate, "SQL template must not be null");
        Objects.requireNonNull(tagToReplace, "Tag to replace must not be null");
        if (questionMarkCount < 0) {
            throw new IllegalArgumentException("Question Marks Count must not be negative" + questionMarkCount);
        }
        String questionMarks = String.join((CharSequence)",", Collections.nCopies(questionMarkCount, SQL_PLACEHOLDER));
        return sqlTemplate.replaceAll(Pattern.quote(tagToReplace), questionMarks);
    }

    protected String getTableName() {
        return "aeo_event_outbox_v1";
    }

    protected String getIdColumnName() {
        return "id";
    }

    protected String getReceivedAtColumnName() {
        return "receivedAt";
    }

    protected String getEventDataColumnName() {
        return "event";
    }

    protected abstract SqlStatement getCreateTableStatement();

    protected abstract SqlStatement getInsertEventStatement(InternalEvent var1);

    protected abstract SqlStatement getFetchEventsStatement(int var1);

    protected abstract SqlStatement getDeleteEventsStatement(Connection var1, List<Long> var2);

    protected abstract SqlStatement getStatsStatement();

    private static void requireValidFetchLimit(int fetchLimit) {
        if (fetchLimit <= 0) {
            throw new IllegalArgumentException("fetchLimit must be positive number.");
        }
    }

    protected static class SqlStatement {
        private final String sql;
        private final List<StatementPreparer> preparers;

        private SqlStatement(String sql, List<StatementPreparer> preparers) {
            this.sql = sql;
            this.preparers = preparers;
        }

        static SqlStatement create(String sql, StatementPreparer ... preparers) {
            return new SqlStatement(sql, List.of(preparers));
        }

        <T> T execute(Connection connection, StatementProcessor<T> statementProcessor) throws SQLException {
            try (PreparedStatement preparedStatement = this.createPreparedStatement(connection);){
                this.prepare(preparedStatement);
                T t = statementProcessor.process(preparedStatement);
                return t;
            }
        }

        PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql);
        }

        private void prepare(PreparedStatement preparedStatement) throws SQLException {
            for (StatementPreparer p : this.preparers) {
                p.prepare(preparedStatement);
            }
        }

        @FunctionalInterface
        private static interface StatementProcessor<T> {
            public T process(PreparedStatement var1) throws SQLException;
        }

        @FunctionalInterface
        static interface StatementPreparer {
            public void prepare(PreparedStatement var1) throws SQLException;
        }
    }

    @FunctionalInterface
    protected static interface SQLFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

