/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.event.outbox.ConnectionSource;
import org.alfresco.event.outbox.Event;
import org.alfresco.event.outbox.EventConsumer;
import org.alfresco.event.outbox.EventProcessor;
import org.alfresco.event.outbox.EventTable;
import org.alfresco.event.outbox.EventTableStats;
import org.alfresco.event.outbox.InternalEvent;
import org.alfresco.event.outbox.Metrics;
import org.alfresco.event.outbox.MetricsAdapter;
import org.alfresco.event.outbox.OutboxConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEventProcessor
implements EventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventProcessor.class);
    private final EventTable eventTable;
    private final ConnectionSource connectionSource;
    private final EventConsumer outboundEventConsumer;
    private final MetricsAdapter metricsAdapter;
    private final OutboxConfig config;
    private final AtomicReference<EventTableStats> latestTableStats = new AtomicReference();

    public DefaultEventProcessor(EventTable eventTable, ConnectionSource connectionSource, EventConsumer outboundEventConsumer, MetricsAdapter metricsAdapter, OutboxConfig config) {
        this.eventTable = eventTable;
        this.connectionSource = connectionSource;
        this.outboundEventConsumer = outboundEventConsumer;
        this.metricsAdapter = metricsAdapter;
        this.config = config;
    }

    @Override
    public EventTableStats getStats() {
        return this.latestTableStats.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Duration processEvents() {
        MetricsAdapter.MetricId metric;
        List<InternalEvent> events;
        Connection connection;
        boolean connectionEstablishedSuccessfully;
        boolean batchProcessedSuccessfully;
        Instant processingStart;
        block21: {
            Duration duration;
            block22: {
                LOGGER.debug("Processing events.");
                processingStart = Instant.now();
                batchProcessedSuccessfully = false;
                connectionEstablishedSuccessfully = false;
                connection = this.connectionSource.getNonTxBoundConnection();
                connectionEstablishedSuccessfully = true;
                connection.setTransactionIsolation(2);
                connection.setAutoCommit(true);
                this.computeStatsIfNeeded(connection);
                connection.setAutoCommit(false);
                events = this.eventTable.fetchEvents(connection, this.config.getFetchLimit());
                if (!events.isEmpty()) break block21;
                batchProcessedSuccessfully = true;
                duration = this.config.getProcessingDelayWhenNoEvents();
                if (connection == null) break block22;
                connection.close();
            }
            MetricsAdapter.MetricId metric2 = batchProcessedSuccessfully ? Metrics.BATCH_PROCESSED_SUCCESS : Metrics.BATCH_PROCESSED_FAILURE;
            this.metricsAdapter.report(metric2, Duration.between(processingStart, Instant.now()));
            return duration;
        }
        try {
            block23: {
                ArrayList<Long> processedEventIds = new ArrayList<Long>(events.size());
                try {
                    for (InternalEvent event : events) {
                        this.process(event);
                        processedEventIds.add(event.id());
                    }
                    break block23;
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Failed to process single event ({}: {}). Will retry.", (Object)e.getClass().getName(), (Object)e.getMessage());
                    LOGGER.debug("Single event processing failure.", (Throwable)e);
                    throw e;
                }
                finally {
                    if (!processedEventIds.isEmpty()) {
                        this.eventTable.deleteEvents(connection, processedEventIds);
                        connection.commit();
                        batchProcessedSuccessfully = true;
                    } else {
                        connection.rollback();
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            metric = batchProcessedSuccessfully ? Metrics.BATCH_PROCESSED_SUCCESS : Metrics.BATCH_PROCESSED_FAILURE;
        }
        catch (SQLException e) {
            Duration duration;
            block24: {
                MetricsAdapter.MetricId metric3;
                try {
                    LOGGER.debug("Processing failure.", (Throwable)e);
                    if (!connectionEstablishedSuccessfully) break block24;
                    LOGGER.warn("Failed to process events ({}: {}). Will retry.", (Object)e.getClass().getName(), (Object)e.getMessage());
                    duration = this.config.getProcessingDelayWhenSqlExceptionIsThrown();
                    metric3 = batchProcessedSuccessfully ? Metrics.BATCH_PROCESSED_SUCCESS : Metrics.BATCH_PROCESSED_FAILURE;
                }
                catch (Throwable throwable) {
                    MetricsAdapter.MetricId metric4 = batchProcessedSuccessfully ? Metrics.BATCH_PROCESSED_SUCCESS : Metrics.BATCH_PROCESSED_FAILURE;
                    this.metricsAdapter.report(metric4, Duration.between(processingStart, Instant.now()));
                    throw throwable;
                }
                this.metricsAdapter.report(metric3, Duration.between(processingStart, Instant.now()));
                return duration;
            }
            LOGGER.warn("Failed to establish connection to process events ({}: {}). Will retry.", (Object)e.getClass().getName(), (Object)e.getMessage());
            duration = this.config.getProcessingDelayWhenSqlExceptionIsThrownWhenGettingConnection();
            MetricsAdapter.MetricId metric5 = batchProcessedSuccessfully ? Metrics.BATCH_PROCESSED_SUCCESS : Metrics.BATCH_PROCESSED_FAILURE;
            this.metricsAdapter.report(metric5, Duration.between(processingStart, Instant.now()));
            return duration;
        }
        this.metricsAdapter.report(metric, Duration.between(processingStart, Instant.now()));
        return this.config.getProcessingDelayWhenAtLeastOneEventWasSuccessfullyProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(InternalEvent event) {
        MetricsAdapter.MetricId metric;
        Instant start = Instant.now();
        boolean failed = true;
        try {
            this.outboundEventConsumer.consume(Event.from(event));
            failed = false;
            metric = failed ? Metrics.EVENT_PROCESSED_FAILURE : Metrics.EVENT_PROCESSED_SUCCESS;
        }
        catch (Throwable throwable) {
            MetricsAdapter.MetricId metric2 = failed ? Metrics.EVENT_PROCESSED_FAILURE : Metrics.EVENT_PROCESSED_SUCCESS;
            this.metricsAdapter.report(metric2, Duration.between(start, Instant.now()));
            throw throwable;
        }
        this.metricsAdapter.report(metric, Duration.between(start, Instant.now()));
    }

    private void computeStatsIfNeeded(Connection connection) throws SQLException {
        EventTableStats newStats;
        EventTableStats currentStats = this.latestTableStats.get();
        if ((currentStats == null || this.areExpired(currentStats)) && this.latestTableStats.compareAndSet(currentStats, newStats = this.eventTable.getStats(connection))) {
            this.metricsAdapter.report(Metrics.QUEUE_SIZE, newStats.size());
            this.metricsAdapter.report(Metrics.QUEUE_LAG, newStats.lag().toMillis());
        }
    }

    private boolean areExpired(EventTableStats currentStats) {
        Instant statsExpiryTime = Instant.now().minus(this.config.getQueueStatsReportingInterval());
        return currentStats.collectedAt().isBefore(statsExpiryTime);
    }
}

