/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.alfresco.event.outbox.ConnectionSource;
import org.alfresco.event.outbox.EventConsumer;
import org.alfresco.event.outbox.EventTable;
import org.alfresco.event.outbox.EventTableOutbox;
import org.alfresco.event.outbox.MSSQLEventTable;
import org.alfresco.event.outbox.MySQLEventTable;
import org.alfresco.event.outbox.OracleEventTable;
import org.alfresco.event.outbox.Outbox;
import org.alfresco.event.outbox.OutboxException;
import org.alfresco.event.outbox.PostgresEventTable;

class AutodetectDbOutbox
implements Outbox {
    private final AtomicReference<EventTableOutbox> targetOutbox = new AtomicReference();
    private final ConnectionSource connectionSource;
    private final Function<EventTable, EventTableOutbox> outboxCreator;

    AutodetectDbOutbox(ConnectionSource connectionSource, Function<EventTable, EventTableOutbox> outboxCreator) {
        this.connectionSource = Objects.requireNonNull(connectionSource);
        this.outboxCreator = Objects.requireNonNull(outboxCreator);
    }

    @Override
    public void start() {
        this.getTargetOutbox().start();
    }

    @Override
    public void shutdown() {
        this.getTargetOutbox().shutdown();
    }

    @Override
    public EventConsumer getInboundEventConsumer() {
        return this.getTargetOutbox().getInboundEventConsumer();
    }

    private EventTableOutbox getTargetOutbox() {
        EventTableOutbox current = this.targetOutbox.get();
        if (current != null) {
            return current;
        }
        EventTable eventTable = this.detectDb();
        EventTableOutbox newOutbox = this.outboxCreator.apply(eventTable);
        if (this.targetOutbox.compareAndSet(null, newOutbox)) {
            return newOutbox;
        }
        return this.targetOutbox.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EventTable detectDb() {
        try (Connection connection = this.connectionSource.getNonTxBoundConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            if (this.isPostgreSQL(metadata)) {
                PostgresEventTable postgresEventTable = new PostgresEventTable();
                return postgresEventTable;
            }
            if (this.isMySQL(metadata)) {
                MySQLEventTable mySQLEventTable = new MySQLEventTable();
                return mySQLEventTable;
            }
            if (this.isMariaDB(metadata)) {
                MySQLEventTable mySQLEventTable = new MySQLEventTable();
                return mySQLEventTable;
            }
            if (this.isOracleDB(metadata)) {
                OracleEventTable oracleEventTable = new OracleEventTable();
                return oracleEventTable;
            }
            if (!this.isMSSQL(metadata)) throw new OutboxException("Unable to detect database type (" + metadata.getDatabaseProductName() + ").");
            MSSQLEventTable mSSQLEventTable = new MSSQLEventTable();
            return mSSQLEventTable;
        }
        catch (SQLException e) {
            throw new OutboxException("Failed to detect database type.", e);
        }
    }

    private boolean isMSSQL(DatabaseMetaData metadata) throws SQLException {
        String productName = metadata.getDatabaseProductName();
        return productName != null && productName.toLowerCase(Locale.ROOT).contains("sql server");
    }

    private boolean isOracleDB(DatabaseMetaData metadata) throws SQLException {
        String productName = metadata.getDatabaseProductName();
        return productName != null && productName.toLowerCase(Locale.ROOT).contains("oracle");
    }

    private boolean isMariaDB(DatabaseMetaData metadata) throws SQLException {
        String productName = metadata.getDatabaseProductName();
        return productName != null && productName.toLowerCase(Locale.ROOT).contains("mariadb");
    }

    private boolean isPostgreSQL(DatabaseMetaData metadata) throws SQLException {
        String productName = metadata.getDatabaseProductName();
        return productName != null && productName.toLowerCase(Locale.ROOT).contains("postgre");
    }

    private boolean isMySQL(DatabaseMetaData metadata) throws SQLException {
        String productName = metadata.getDatabaseProductName();
        return productName != null && productName.toLowerCase(Locale.ROOT).contains("mysql");
    }
}

