/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="aimslogouthandler")
public class AIMSLogoutHandler {
    private static final Log logger = LogFactory.getLog(AIMSLogoutHandler.class);
    @Autowired(required=false)
    private ClientRegistrationRepository clientRegistrationRepository;
    @Autowired
    private AIMSConfig aimsConfig;
    private String postLogoutRedirectUri;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String targetUrl = null;
        HashMap<String, String> logoutMap = new HashMap<String, String>();
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(this.aimsConfig.getResource());
        URI endSessionEndpoint = this.endSessionEndpoint(clientRegistration);
        if (endSessionEndpoint != null) {
            URI postLogoutRedirectUri;
            if (this.aimsConfig.getUserIdTokenHint().booleanValue()) {
                logoutMap.put("id_token_hint", this.idToken(authentication));
            }
            if (this.aimsConfig.getLogoutClientIDLabel() != null) {
                logoutMap.put(this.aimsConfig.getLogoutClientIDLabel(), this.aimsConfig.getLogoutClientIDValue());
            }
            if ((postLogoutRedirectUri = this.postLogoutRedirectUri(request, clientRegistration)) != null) {
                if (this.aimsConfig.getPostLogoutRedirectUrlLabel() != null) {
                    logoutMap.put(this.aimsConfig.getPostLogoutRedirectUrlLabel(), this.aimsConfig.getPostLogoutRedirectUrlValue() != null ? this.aimsConfig.getPostLogoutRedirectUrlValue() : postLogoutRedirectUri.toString());
                } else {
                    logoutMap.put("post_logout_redirect_uri", postLogoutRedirectUri.toString());
                }
            }
            targetUrl = this.endpointUri(endSessionEndpoint, logoutMap);
        }
        return targetUrl;
    }

    private URI endSessionEndpoint(ClientRegistration clientRegistration) {
        URI result = null;
        if (clientRegistration != null) {
            if (this.aimsConfig.getLogoutUri() != null) {
                result = URI.create(this.aimsConfig.getLogoutUri());
            } else {
                Object endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint");
                if (endSessionEndpoint != null) {
                    result = URI.create(endSessionEndpoint.toString());
                }
            }
        }
        return result;
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    private URI postLogoutRedirectUri(HttpServletRequest request, ClientRegistration clientRegistration) {
        if (clientRegistration != null) {
            String postLogoutEndpoint = this.aimsConfig.getPostLogoutUrl();
            if (postLogoutEndpoint == null) {
                postLogoutEndpoint = (String)clientRegistration.getProviderDetails().getConfigurationMetadata().get("post_redirect_uri");
            }
            UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
            if (postLogoutEndpoint == null || postLogoutEndpoint.isEmpty()) {
                return UriComponentsBuilder.fromUriString((String)(String.valueOf(request.getRequestURL()) + "?success")).buildAndExpand(Collections.singletonMap("baseUrl", uriComponents.toUriString())).toUri();
            }
            return UriComponentsBuilder.fromUriString((String)postLogoutEndpoint).buildAndExpand(Collections.singletonMap("baseUrl", uriComponents.toUriString())).toUri();
        }
        return null;
    }

    private String endpointUri(URI endSessionEndpoint, HashMap<String, String> logoutMap) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        logoutMap.forEach((key, value) -> builder.queryParam(key, new Object[]{value}));
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    @Deprecated
    public void setPostLogoutRedirectUri(URI postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri.toASCIIString();
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String targetUrl = this.determineTargetUrl(request, response, authentication);
        logger.debug((Object)("Value of targetUrl is: " + targetUrl));
        if (response.isCommitted()) {
            logger.error((Object)("Can't perform the redirect for the targetUrl: " + targetUrl));
        } else {
            this.redirectStrategy.sendRedirect(request, response, targetUrl);
        }
    }
}

