/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.Iterator;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

class ConstraintHandlersElementReader
implements ConfigElementReader {
    public static final String ELEMENT_CONSTRAINT_HANDLERS = "constraint-handlers";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALIDATOR_HANDLER = "validation-handler";
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_MESSAGE_ID = "message-id";
    public static final String ATTR_EVENT = "event";

    ConstraintHandlersElementReader() {
    }

    public ConfigElement parse(Element element) {
        ConstraintHandlersConfigElement result = null;
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (!name.equals(ELEMENT_CONSTRAINT_HANDLERS)) {
            throw new ConfigException(this.getClass().getName() + " can only parse constraint-handlers elements, the element passed was '" + name + "'");
        }
        result = new ConstraintHandlersConfigElement();
        Iterator xmlNodes = element.elementIterator();
        while (xmlNodes.hasNext()) {
            Element nextNode = (Element)xmlNodes.next();
            String type = nextNode.attributeValue(ATTR_TYPE);
            String validationHandler = nextNode.attributeValue(ATTR_VALIDATOR_HANDLER);
            String message = nextNode.attributeValue(ATTR_MESSAGE);
            String messageId = nextNode.attributeValue(ATTR_MESSAGE_ID);
            String event = nextNode.attributeValue(ATTR_EVENT);
            result.addDataMapping(type, validationHandler, message, messageId, event);
        }
        return result;
    }
}

